---
title: How to Track PMF Progress Without Invalidating Comparisons
impact: MEDIUM
tags: tracking, methodology, measurement
---

## How to Track PMF Progress Without Invalidating Comparisons

Running the survey quarterly is essential, but changing methodology between runs makes comparisons meaningless. Consistency matters more than perfection.

**Incorrect (inconsistent methodology):**

> **Q1 Survey:**
> - Email survey to all users
> - Question: "How disappointed would you be..."
> - Result: 32% very disappointed
>
> **Q2 Survey:**
> - In-app popup to active users only
> - Question: "How would you feel if you couldn't use..."
> - Result: 41% very disappointed
>
> **Team's conclusion:** "Our PMF improved 9 points! The roadmap is working!"

But you changed three things: delivery method, audience, and question wording. You can't attribute the change to product improvement.

**Correct (consistent methodology):**

> **Establish baseline methodology:**
> - Delivery: In-app survey
> - Audience: Users who completed onboarding + 3 core actions + active in past 14 days
> - Question: Exact Sean Ellis wording
> - Timing: First week of each quarter
>
> **Every quarter, same methodology:**
> - Q1: 32%
> - Q2: 35%
> - Q3: 38%
> - Q4: 42%
>
> **Team's conclusion:** "Consistent 3-4 point improvement each quarter. Our roadmap is working. We crossed the 40% threshold in Q4."

If you must change methodology (e.g., switching from email to in-app), acknowledge it's a new baseline and don't compare to previous numbers.

**Why it matters:**

PMF tracking is only useful if you can compare over time. Methodology changes are confounding variables. Keep everything constant so changes in score reflect actual changes in product-market fit.
