---
title: Survey After First Value, Not After Signup
impact: HIGH
tags: timing, methodology, activation
---

## Survey After First Value, Not After Signup

Surveying users right after signup measures onboarding UX, not product value. Users can't tell you if they'd miss your product when they haven't really used it yet.

**Incorrect (survey too early):**

> **Trigger:** Survey pops up 24 hours after account creation
>
> **User's thought process:** "I signed up yesterday, clicked around a bit, looks nice I guess? Would I be disappointed if I couldn't use it? I mean... I barely know what it does."
>
> **Result:** High "Not Disappointed" responses from users who haven't experienced value yet.

**Correct (survey after activation):**

> **Trigger:** Survey appears after user has:
> - Completed core onboarding
> - Used the main feature at least 3 times
> - Been active for at least 2 weeks
>
> **User's thought process:** "I've been using this for two weeks now. It's become part of my workflow. Would I be disappointed? Let me think about what my day would look like without it..."
>
> **Result:** Responses reflect actual product value, not first impressions.

For Superhuman, this meant surveying users who had processed a meaningful volume of email, not users who had just connected their account.

**Why it matters:**

The PMF question measures dependence. Users can't be dependent on something they haven't experienced. Early surveys tell you about signup friction and first impressions - useful, but different from PMF.
