# PMF Scorecard (Investor-Ready, Trackable)

## 0) One-page dashboard (fill this in each month/quarter)

| Metric | Current | Previous | Target next | Notes |
|---|---:|---:|---:|---|
| PMF Score (Eligible Users) | ___% | ___% | ___% | % “Very disappointed” |
| PMF Score (Best Segment: ________) | ___% | ___% | ___% | define segment clearly |
| Activation rate (Signup → Aha ≤ N days) | ___% | ___% | ___% | N = ___ days |
| Median time-to-first-value (Signup → Aha) | ___ | ___ | ___ | in hours/days |
| Activated retention (W4 or D30) | ___% | ___% | ___% | among Aha users |

## 1) Pick the cohort you’ll measure (separates “activation” from “PMF”)

Define **Eligible Users** = people who have experienced your core value (not just signed up).

- **Activation (“Aha”) definition:** `_________________________` (the moment value becomes obvious)
- **Eligibility rule (example):** completed onboarding + performed core action ≥3 times + active in last 14 days
- **Exclude:** never-activated users, employer-mandated users, users who haven’t reached Aha yet

This is how you avoid confusing “onboarding is broken” with “product has no PMF”.

## 2) Your primary PMF metric (simple, comparable over time)

Run the **PMF Survey** on Eligible Users and track:

**PMF Score = % of respondents who answer “Very disappointed”** to the standard question.

Benchmarks (heuristic, not a finish line):
- **40%+**: strong PMF → lean into growth
- **25–40%**: promising → improve PMF before scaling spend
- **<25%**: weak → focus on finding a stronger segment/value prop

## 3) Segment it (this is usually where the story is)

Always compute PMF Score for:
- **Overall Eligible Users**
- **Top segment(s)** by role/use case/company size/channel/pricing tier

Investor-grade framing is often: “Overall is mixed, but Segment X is already at/near PMF; we’re focusing there.”

## 4) Add 3 supporting metrics (so you can act, not just measure)

Track alongside PMF Score:

- **Activation rate:** `% of new signups who reach Aha within N days`
- **Time-to-first-value:** median time from signup → Aha
- **Activated retention:** `W4 (or D30) retention` among users who reached Aha

If PMF Score is decent but activation/TTFV is poor, you likely have an onboarding/discovery problem (fixable).
If activation is fine but PMF Score is low, the product is reaching people who don’t truly need it (positioning/ICP).

## 5) “PMF Engine” roadmap rule (how to move the number)

From PMF survey responses, split users into:
- **Very disappointed (lovers):** protect and double down on the main benefit they cite
- **Somewhat disappointed (fence-sitters):** convert only those whose “main benefit” matches the lovers
- **Not disappointed:** don’t build for them

Default effort split:
- **~50%**: double down on what lovers love
- **~50%**: remove the top blockers for convertible fence-sitters

## 6) Tracking cadence (keep comparisons valid)

- Run monthly or quarterly, but keep **the same**: question wording, delivery channel, eligibility rule, and timing.
- If you change methodology, treat it as a **new baseline** (don’t compare to prior scores).

## 7) What to show investors (one slide)

- PMF Score over time: overall + best segment
- Eligible Users definition (1 line)
- Activated retention trend
- The 2–3 roadmap bets tied directly to “convertible fence-sitter” blockers
