---
name: positioning-canvas
description: Use when asked to "position my product", "positioning canvas", "differentiate from competitors", "figure out our category", "repositioning", or "why customers should pick us". Helps define competitive alternatives, differentiated value, target customers, and market category. April Dunford's positioning framework from "Obviously Awesome" makes your product's value obvious to the right customers.
---

# Positioning Canvas

## What It Is

Positioning defines how your product is the best in the world at delivering some value that a well-defined set of customers care a lot about.

**The core insight:** Positioning is not messaging. It's not your tagline. It's the fundamental strategic decision about how you win in the market — what you compete against, how you're different, what value only you can deliver, and who cares most about that value.

When positioning is weak:
- Prospects don't understand what you are on first contact
- Sales calls require 3+ meetings before "the light comes on"
- You win deals but customers churn because expectations didn't match reality
- Different teams (sales, marketing, product) tell different stories

When positioning is strong:
- It feels obvious — "of course that's what it is"
- Qualified prospects immediately understand why they should care
- Your differentiated value is clear against alternatives
- Everyone in the company tells the same story

**Credit:** This framework comes from April Dunford, author of *Obviously Awesome* and *Sales Pitch*, who has positioned over 200 B2B tech companies.

## When to Use It

Use Positioning Canvas when you need to:

- **Define or refine how you compete** — who are the real alternatives?
- **Articulate differentiated value** — why pick you over everything else?
- **Identify your best-fit customers** — who cares most about your value?
- **Choose or validate your market category** — what context makes your value obvious?
- **Align your team** — get sales, marketing, product, and leadership on the same page
- **Build a sales pitch** — translate positioning into a story that wins deals
- **Reposition after market changes** — your product evolved, competition shifted, or customers changed

## When Not to Use It

**Don't use Positioning Canvas when:**

- **You're pre-product-market-fit** — Keep positioning loose until you see patterns in who loves you and why. You need ~10+ happy customers to have enough signal.
- **You want to validate a hypothesis** — Positioning captures what's true today based on evidence, not what you hope becomes true.
- **You're only focused on messaging** — Positioning is an input to messaging, not messaging itself. Get positioning right first.
- **You're doing competitive research** — Positioning defines how you win, not a comprehensive market map.

**Early-stage exception:** If you're launching, create a positioning *thesis* — your best guess at all five components. Keep it loose, test with real customers, and tighten as patterns emerge.

## Patterns

Detailed examples showing how to apply positioning correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [starting-with-category](patterns/starting-with-category.md) | Don't start with market category — start with competitive alternatives |
| [competitive-alternatives-vs-competitors](patterns/competitive-alternatives-vs-competitors.md) | Status quo and "do nothing" are often your real competition |
| [features-vs-value](patterns/features-vs-value.md) | Capabilities aren't value — translate the "so what?" |
| [conference-room-positioning](patterns/conference-room-positioning.md) | You can't position without customer evidence |
| [misaligned-teams](patterns/misaligned-teams.md) | Positioning requires cross-functional alignment |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [too-broad-target](patterns/too-broad-target.md) | "Everyone" is not a target — get specific about who cares most |
| [undifferentiated-value](patterns/undifferentiated-value.md) | If competitors can claim it too, it's not differentiated value |
| [no-decision-loss](patterns/no-decision-loss.md) | 40-60% of deals die to indecision, not competitors |
| [category-creation-timing](patterns/category-creation-timing.md) | Category creation works after dominance, not before |
| [repositioning-triggers](patterns/repositioning-triggers.md) | Know when positioning needs a refresh |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [bowling-pin-strategy](patterns/bowling-pin-strategy.md) | Dominate a beachhead before expanding |
| [sales-pitch-feature-dump](patterns/sales-pitch-feature-dump.md) | Product demos should prove value, not expose features |
| [teaching-how-to-buy](patterns/teaching-how-to-buy.md) | Help confused buyers make confident decisions |
| [champion-vs-personas](patterns/champion-vs-personas.md) | Focus positioning on the champion, arm them for others |


## Deep Dives

Read only when you need extra detail.

- `references/positioning-canvas-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Obviously Awesome* by April Dunford — The complete positioning methodology
- *Sales Pitch* by April Dunford — Translating positioning into sales narratives
- *Positioning: The Battle for Your Mind* by Al Ries and Jack Trout — The foundational theory

**Complementary:**
- *The JOLT Effect* by Matt Dixon — Research on why deals stall and how to overcome indecision
- *The Challenger Sale* by Matt Dixon — Teaching customers how to buy
- *Crossing the Chasm* by Geoffrey Moore — Bowling pin strategy and market adoption

**From April Dunford:**
- Newsletter: aprildunford.com
- Podcast: "Positioning with April Dunford"
