---
title: Category Creation Works After Dominance, Not Before
impact: HIGH
tags: category, strategy, timing
---

## Category Creation Works After Dominance, Not Before

Creating a new category is an expensive, risky strategy that works best *after* you dominate a niche — not as a way to get started. Most successful "category creators" actually followed bowling pin strategy first.

**Incorrect (premature category creation):**

> **Seed-stage startup positioning:**
> "We're not CRM, we're not sales enablement — we're the first Revenue Optimization Platform. We're creating a new category."
>
> **Problems:**
> - Customers don't know what "Revenue Optimization Platform" means
> - You have to educate the market (expensive) while also selling (hard)
> - If category takes off, well-funded competitors follow with better resources
> - Most category creators get overtaken by fast-followers (see: MySpace, Ask Jeeves)

**Correct (dominate a beachhead first):**

> **Actual paths of "category creators":**
>
> **Salesforce:** Started as "CRM for small businesses" (existing category, new segment). Dominated. Then expanded to "cloud CRM." Then "CRM platform." Then "customer company."
>
> **Qualtrics:** Survey software for 15+ years. Reached $300M+ revenue. *Then* rebranded as "Experience Management Platform."
>
> **Snowflake:** "Data warehousing in the cloud" (existing category + new delivery). Dominated. Pre-IPO, expanded to "Data Cloud."
>
> **The pattern:** Niche dominance first. Category expansion second.

**When category creation makes sense:**

- You've dominated your beachhead
- You're $50M+ revenue and need a growth narrative
- You have budget to educate the market for years
- You're willing to risk fast-followers if category takes off

**Why it matters:**

Category creation without dominance means paying to educate a market that competitors then harvest. It's the right move at the right stage — but most startups aren't at that stage.
