---
title: Know When Positioning Needs a Refresh
impact: HIGH
tags: repositioning, triggers, change
---

## Know When Positioning Needs a Refresh

Positioning isn't permanent. Markets shift, products evolve, and competitors emerge. Knowing when to revisit positioning is as important as getting it right initially.

**Incorrect (treating positioning as fixed):**

> **Three years after initial positioning:**
>
> **What's changed:**
> - Product has evolved significantly (new AI features, new integrations)
> - Main competitor was acquired and pivoted
> - Target market has matured (what was innovative is now expected)
> - New category of tools emerged that didn't exist before
>
> **What the team does:** Nothing. "We did positioning three years ago. It's on the website."
>
> **Result:** Sales conversations feel harder. Win rates drop. Marketing campaigns underperform. Nobody connects the dots back to positioning drift.

**Correct (recognizing repositioning triggers):**

> **Trigger checklist — revisit positioning when:**
>
> **Market changes:**
> - [ ] Major competitor entered, exited, or pivoted
> - [ ] New category emerged that overlaps with you
> - [ ] Market matured (differentiation that worked now feels table-stakes)
> - [ ] Buyer expectations shifted (COVID changed remote work assumptions forever)
>
> **Product changes:**
> - [ ] Major capability added that changes what you can claim
> - [ ] Core technology shifted (rebuilt platform, new architecture)
> - [ ] Portfolio expanded (acquisitions, new products)
>
> **Performance signals:**
> - [ ] Sales conversations getting harder (more objections, longer cycles)
> - [ ] Win rates declining against specific competitors
> - [ ] Losing to "no decision" more often
> - [ ] Churn increasing for positioning-related reasons (expectations mismatch)
>
> **Team signals:**
> - [ ] New leadership joined with different market view
> - [ ] Sales and marketing telling different stories again
> - [ ] "What do we actually do?" becoming a common internal question

**Why it matters:**

Good positioning has a shelf life. The companies that consistently win are the ones that periodically check: "Does our positioning still reflect how we win?" Don't wait for a crisis — schedule an annual positioning review.
