# Positioning Canvas Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Five Components of Positioning

Positioning has five components that must be developed **in order**. Each component builds on the previous one.

```
COMPETITIVE        UNIQUE          DIFFERENTIATED      TARGET           MARKET
ALTERNATIVES  -->  ATTRIBUTES  -->  VALUE          -->  CUSTOMERS   -->  CATEGORY

"What would       "What do we     "So what?           "Who cares       "What context
customers do      have that       What does this      most about       makes our value
if we didn't      they don't?"    enable for          this value?"     obvious?"
exist?"                           customers?"
```

### 1. Competitive Alternatives

**Question:** What would customers do if you didn't exist?

This is NOT a list of products in your category. It's whatever customers would actually use to solve their problem — including:

- **Status quo** — spreadsheets, manual processes, interns, doing nothing
- **Shortlist alternatives** — what else lands on the evaluation list

**Why it matters:** In B2B, ~40% of deals are lost to "no decision" — the customer couldn't figure out how to choose, so they stuck with status quo. You're not just competing with Zendesk; you're competing with "we'll just keep using email."

**How to find them:** Ask sales. They know exactly what they're displacing in every deal.

### 2. Unique Attributes (Capabilities)

**Question:** What capabilities do you have that the alternatives don't?

Make a list of everything that differentiates you:
- Features and functionality
- Pricing model
- Professional services
- Technology architecture
- Company capabilities (support, expertise, partnerships)

**Important:** These are capabilities, not value. A capability is "we're built on Salesforce." The value comes next.

### 3. Differentiated Value

**Question:** So what? What does each capability enable for customers?

Translate each unique capability into customer value by repeatedly asking "so what?"

**Example:**
- Capability: "Built on Salesforce"
- So what? "Sales enablement data integrated with sales data"
- So what? "Can measure if enablement improved time to first deal"
- So what? "Prove enablement ROI with actual revenue metrics"
- **Differentiated Value:** "Measure sales enablement impact on revenue"

Value themes will emerge. You'll typically end up with 2-3 major value buckets.

**The test:** If a competitor can claim the same value, it's not differentiated. "We save you time" isn't differentiated. "We're the only solution that can prove ROI on sales enablement" might be.

### 4. Target Customers

**Question:** Who cares most about this differentiated value?

Not everyone values your differentiation equally. Identify the characteristics of accounts that make them care deeply about your value:

- Company attributes (size, industry, growth stage)
- Technology stack ("they use Salesforce")
- Team characteristics ("marketing team with 3+ people")
- Situation triggers ("just lost a client due to missed deadline")

**Important:** This is about companies/accounts (segmentation), not just buyer personas. In B2B, you need to know which *companies* to target, then who the champion is within those companies.

### 5. Market Category

**Question:** What context makes your value obvious to your target customers?

Market category is NOT a label you slap on — it's a strategic choice about the context you position in.

The job of a market category is to help answer: "What is this thing?"

When you say "CRM," customers instantly know:
- What problem it solves
- Who uses it
- What features to expect
- Who the competitors are

**How to choose:** Pick the category where your differentiated value is most obviously valuable to your target customers. Sometimes that's an existing category. Sometimes it's a subcategory. Rarely (and only after dominance), it's a new category.

## The Positioning Process

### Who Needs to Be in the Room

Positioning is a team sport. Include:
- **CEO / Founder** — They often have the clearest intuition about value
- **Head of Sales** — They know what wins and loses deals
- **Head of Marketing** — They'll translate positioning to messaging
- **Head of Product** — They know the differentiation deeply
- **Customer Success** — They know why customers stay or churn

**Why cross-functional?** If one team creates positioning and "heaves it over the wall," it won't stick. Sales will ignore it. Product will disagree. You need alignment from the start.

### Step-by-Step

1. **Document competitive alternatives** — What do we beat to win a deal? (Status quo + shortlist)
2. **List unique capabilities** — What do we have that alternatives don't?
3. **Map capabilities to value** — For each capability, ask "so what?" until you reach customer impact
4. **Identify value themes** — Group into 2-3 differentiated value buckets
5. **Define target customer characteristics** — What makes a company care about this value?
6. **Choose market category** — What context makes our value obvious to our targets?
7. **Document and align** — Create a positioning document everyone agrees to
8. **Build the sales narrative** — Translate positioning into a pitch structure (see below)

### Timeline

- **Positioning workshop:** 3-5 days for the core exercise
- **Sales pitch development:** 1-2 weeks to build and rehearse
- **Testing:** 2-4 weeks of live prospect calls
- **Rollout:** Train the full team once validated

## From Positioning to Sales Pitch

Positioning is useless if it doesn't change how you sell. The positioning canvas translates directly into a sales pitch structure.

### The Sales Pitch Structure

**Setup (Context):**

1. **Insight** — Your point of view on the market. What do customers need to understand about the world that makes your value important?

2. **Alternative approaches** — Paint the picture of options: "There's approach A, which is good for X but bad for Y. There's approach B, which is good for Z but bad for W."

3. **Perfect world** — "Can we agree that a really good solution would have A, B, and C?" Get alignment before talking about yourself.

**Follow-through (Value):**

4. **Introduction** — "We're [company], [market category] for [target customers]."

5. **Differentiated value** — "Here's how we deliver on those requirements." Demo/show each value bucket with supporting features.

6. **Proof** — Customer case studies, third-party validation, data that proves you deliver.

7. **Objections** — Handle the silent worries: "IT might be concerned about X — here's how we address that."

8. **The Ask** — What's the next step in your sales process?

### Example: Help Scout

**Setup:**
- *Insight:* "Digital businesses see customer service as a growth driver, not a cost center. Great service builds loyalty and repeat purchases."
- *Alternatives:* "Most companies start with a shared inbox — easy but you outgrow it. Then they move to help desk software — powerful but designed to minimize cost, not delight customers."
- *Perfect world:* "Can we agree you want something as easy as an inbox, that you'll never outgrow, built to deliver amazing service?"

**Follow-through:**
- *Intro:* "We're Help Scout, customer service software for digital businesses."
- *Value:* "Easy like an inbox — [show]. Features you won't outgrow — [show]. Built for amazing service — [show]."
- *Proof:* Customer story showing improved loyalty/repeat rates.
- *Ask:* "Who else needs to be involved to evaluate this?"

## Common Mistakes

### 1. Starting with Market Category
Many teams start by deciding "we're a CRM" or "we're in the collaboration space" and then backfill everything else. This is backwards. You can't judge if a category is right until you know your differentiated value and target customers.

### 2. Confusing Capabilities with Value
"We have AI" is not value. "You can analyze 10x more customer conversations without hiring analysts" is value. Always ask "so what?" until you reach customer impact.

### 3. Positioning by Committee Email Thread
Positioning requires real-time discussion, debate, and alignment. You can't do it asynchronously. Get everyone in a room (or Zoom) with a whiteboard.

### 4. Ignoring Status Quo
40% of B2B deals are lost to "no decision." Your positioning must make clear why status quo (spreadsheets, manual processes, doing nothing) is unacceptable.

### 5. Too Many Value Props
If you have 8 differentiated value statements, you have zero. Customers can't remember 8 things. Narrow to 2-3 themes that matter most to your target customers.

### 6. Positioning as a One-Time Exercise
Markets shift. Products evolve. Competitors emerge. Check your positioning annually or when you notice sales conversations getting harder.

## Application Checklists

### For Positioning Development

- [ ] Do we have 10+ happy, paying customers to learn from?
- [ ] Is the full cross-functional team committed to participate?
- [ ] Have we documented what we compete against (including status quo)?
- [ ] Can we articulate value that no competitor can claim?
- [ ] Do we know the characteristics of accounts that care most?
- [ ] Does our market category make our value obvious?
- [ ] Is the team aligned on all five components?

### For Sales Pitch Development

- [ ] Does our pitch start with insight, not features?
- [ ] Do we paint the picture of alternatives (pros and cons)?
- [ ] Do we get agreement on "perfect world" before demoing?
- [ ] Is the demo organized around value themes, not feature menus?
- [ ] Do we have proof (case studies, data) for each value claim?
- [ ] Have we addressed common silent objections?
- [ ] Does our best rep believe the new pitch is better?
- [ ] Have we tested with qualified prospects (not existing customers)?

### For Repositioning Triggers

Consider repositioning when:
- [ ] Market has shifted significantly since last positioning work
- [ ] Product capabilities have changed substantially
- [ ] New competitors have emerged that change the landscape
- [ ] You're losing deals for different reasons than before
- [ ] Sales conversations feel harder than they used to
- [ ] Teams are telling different stories about what you do

## Quick Reference

**The five components (in order):**
1. Competitive Alternatives — what would customers do instead?
2. Unique Attributes — what do we have that they don't?
3. Differentiated Value — so what does that enable?
4. Target Customers — who cares most about that value?
5. Market Category — what context makes our value obvious?

**The sales pitch structure:**
- Setup: Insight, Alternatives, Perfect World
- Follow-through: Introduction, Differentiated Value (with demo), Proof, Objections, Ask

**Key insight:** "40-60% of B2B deals end in no decision. The customer couldn't figure out how to choose confidently, so they did nothing. Help them buy."

---

