---
name: product-led-growth
description: Use when asked about "product-led growth", "PLG strategy", "self-serve growth", "freemium model", "free trial design", "product-led sales", "PQL", or "bottoms-up growth". Helps design and optimize product-led growth motions where the product drives acquisition, activation, and monetization. Based on frameworks from Elena Verna and Hila Qu.
---

# Product-Led Growth (PLG)

## What It Is

Product-Led Growth is a go-to-market strategy where the product itself drives acquisition, activation, retention, and monetization. Instead of relying on sales to close deals before users can try the product, PLG lets users experience value first and buy later.

The core insight: **In PLG, the product does the selling.** Users sign up, experience value through self-serve, and either convert themselves or become qualified leads for sales.

PLG is fundamentally **Data-Led Growth (DLG)**. When you give away a free product, you get two things in exchange: broader reach (lower barrier to entry) and usage data that tells you which features correlate with conversion and retention. Without this data foundation, you're giving away your product for nothing.

## When to Use It

Use PLG frameworks when you need to:

- **Design a freemium or free trial model** for a B2B SaaS product
- **Add self-serve to a sales-led product** to expand reach
- **Optimize conversion** from free to paid users
- **Define product-qualified leads (PQLs)** for your sales team
- **Reduce customer acquisition cost** through self-serve
- **Build a hybrid PLG + sales motion** (product-led sales)
- **Diagnose why free users aren't converting** to paid
- **Decide between freemium vs. free trial** models

## When Not to Use It

PLG is not always the right motion:

- **Highly complex products requiring customization** — If users can't see value without significant setup or professional services, PLG struggles
- **Very small addressable market** — If you have 50 potential customers (e.g., defense contractors), sales-led is more efficient
- **No individual use case exists** — PLG requires an individual problem that one person can solve; if value only emerges at team/company scale, start with sales
- **You lack data infrastructure** — Without product analytics, you're flying blind
- **You want instant revenue impact** — PLG takes 12+ months to generate meaningful pipeline; it's a long-term play

## Patterns

Detailed examples showing how to apply PLG correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [plg-without-individual-use-case](patterns/plg-without-individual-use-case.md) | PLG requires an individual job-to-be-done before it can scale to teams |
| [freemium-cannibalizes-revenue](patterns/freemium-cannibalizes-revenue.md) | Free tiers should create demand for paid, not satisfy it |
| [no-activation-focus](patterns/no-activation-focus.md) | Most free users never see value — activation is the biggest lever |
| [sales-spam-on-signup](patterns/sales-spam-on-signup.md) | New signups are not MQLs — they're at the wrong stage for sales |
| [product-not-accountable](patterns/product-not-accountable.md) | PLG fails when product doesn't own monetization metrics |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [pql-without-buyer](patterns/pql-without-buyer.md) | Usage alone doesn't create pipeline — you need to find the buyer |
| [confusing-pls-with-plg](patterns/confusing-pls-with-plg.md) | Product-led sales and product-led growth are different motions |
| [time-to-value-too-long](patterns/time-to-value-too-long.md) | If aha moment takes weeks, users churn before they convert |
| [monetization-awareness-gap](patterns/monetization-awareness-gap.md) | 75% of free users don't know what you're selling |
| [wrong-pqa-definition](patterns/wrong-pqa-definition.md) | PQA thresholds should come from data, not intuition |
| [growth-team-too-early](patterns/growth-team-too-early.md) | You can't outsource product-market fit to a growth team |
| [plg-in-marketing](patterns/plg-in-marketing.md) | PLG fails when run from marketing — product must own it |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [trial-vs-freemium-wrong-choice](patterns/trial-vs-freemium-wrong-choice.md) | Trial and freemium serve different purposes — pick based on your product |
| [ignoring-behavioral-signals](patterns/ignoring-behavioral-signals.md) | Admin changes, terms of use views, and velocity spikes are gold |
| [skipping-profiling-questions](patterns/skipping-profiling-questions.md) | You need to know who users are to serve them correctly |

---


## Deep Dives

Read only when you need extra detail.

- `references/product-led-growth-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**People to follow:**
- Elena Verna (Substack, LinkedIn) — PLG, PLS, growth strategy
- Hila Qu — PLG implementation, activation, growth teams

**Reforge courses:**
- Product-Led Growth course (Elena Verna)
- Growth Series, Experimentation, Monetization

**Tools mentioned:**
- Product analytics: Amplitude, Mixpanel, PostHog
- Data hub: Segment
- Experimentation: Optimizely, Amplitude Experiment, Eppo
- Lifecycle marketing: Customer.io, Iterable
- Data enrichment: Clearbit, ZoomInfo
- Onboarding: Appcues, UserGuiding
- PLS platforms: Pocus, Endgame, Correlated
