---
title: Confusing Product-Led Sales with Product-Led Growth
impact: HIGH
tags: strategy, product-led-sales, definitions
---

## Confusing Product-Led Sales with Product-Led Growth

Product-Led Growth and Product-Led Sales are related but different motions. PLG is about self-serve acquisition and monetization. PLS is about using product usage to create sales pipeline. Confusing them leads to wrong investments.

**Incorrect (conflating PLG and PLS):**

> **CEO in board meeting:**
>
> "We're going product-led. That means we're adding a free tier and our sales team will close the free users."
>
> **What happens:**
> - Product builds free tier
> - Sales starts calling free users immediately
> - Users are annoyed (they wanted self-serve)
> - Sales complains leads are low quality
> - Free tier is labeled a failure
>
> *Result:* Company concludes "PLG doesn't work for us" without ever actually doing PLG.

**Correct (understanding the distinct motions):**

> **CEO in board meeting:**
>
> "We're adding PLG — self-serve acquisition and monetization for SMB. We expect 5% of free users to convert via credit card, no sales touch."
>
> "We're also building PLS — using product usage to create enterprise pipeline. When accounts hit PQA thresholds (7+ users, high feature adoption), sales engages. This is for $50K+ deals where we go find the buyer."
>
> **Two distinct funnels:**
> - PLG → Self-serve → Credit card purchase
> - PLG → PQA → Sales → Enterprise contract
>
> *Result:* Each motion has clear goals, metrics, and team accountability.

**Why it matters:**

PLG without sales is viable (many SMB products). Sales without PLG is viable (traditional enterprise). PLS requires BOTH — the "product-led" part (free signups, usage data) AND the "sales" part (human closes the deal). If you say "we're doing PLG" but mean "sales will close free users," you've set yourself up for failure.
