---
title: Users Don't Know What You're Selling
impact: HIGH
tags: monetization, conversion, pricing, freemium
---

## Users Don't Know What You're Selling

75% of freemium users have no idea what features are in your paid plan. They're not choosing to stay free — they don't know what they're missing.

**Incorrect (paid features invisible to free users):**

> **Product Design Philosophy:**
>
> "We only show users features they have access to. Paid features don't appear in the UI for free users — we don't want to frustrate them."
>
> **Result:**
> - Free users never encounter paid features
> - When surveyed, 80% can't name a single paid feature
> - Users who DO upgrade say "I didn't know that existed!"
> - Conversion rate: 2%

**Correct (making paid features visible and desirable):**

> **Product Design Philosophy:**
>
> "Free users should see paid features everywhere — grayed out with clear explanations of what they do. We want them to WANT them."
>
> **Implementation:**
> - Feature walls: "Advanced Analytics is a Pro feature. See how your data changes over time. [Upgrade]"
> - Usage walls: "You've used 80% of your 3 free boards. Upgrade for unlimited."
> - Consistent visual language: All upgrade touchpoints use gold accent color
> - Rule of three: Each user sees upgrade opportunities at least 3x in their first week
>
> **Design reviews:** Every feature is reviewed from free user state — "Can they see this exists? Do they understand the value?"
>
> **Result:**
> - Pricing page views 4x
> - 60% of free users can name 2+ paid features
> - Conversion rate: 6%

**Why it matters:**

Monetization awareness is often the highest-leverage conversion optimization. You don't need better features — you need users to KNOW about the features you already have. Survey your free users: "What features do you think are in our paid plan?" If they can't answer, you've found your problem.
