---
title: Copying Programmatic SEO Without the Use Case
impact: CRITICAL
tags: programmatic, strategy, zapier
---

## Copying Programmatic SEO Without the Use Case

Zapier's integration pages work because users actually search for "Gmail + Salesforce." Copying their approach without validating search demand creates scale without value.

**Incorrect (programmatic without demand):**

> **Product Team Meeting:**
>
> "Zapier has millions of pages for every integration combination. Canva has templates for everything. We should do the same thing!"
>
> Plan: Create pages for every possible combination of our product with other tools:
> - "Use [Our Tool] with Slack"
> - "Use [Our Tool] with Notion"
> - "[Our Tool] + Airtable Integration"
>
> *Launched 5,000 pages.*
>
> *Six months later:* Total traffic from all 5,000 pages: 200 visits/month. No one searches for these combinations because our tool doesn't have those integrations, and even if it did, users don't think about our product that way.

**Correct (validating the use case first):**

> **Product Team Meeting:**
>
> "Zapier's strategy works because their product IS connecting tools. Users naturally search for integrations.
>
> What do our users actually search for? Let's check:
> - Our sales calls: People ask about specific use cases, not integrations
> - Google Search Console: Top queries are about solving specific problems
> - Customer support: Questions are about accomplishing tasks, not connecting tools
>
> Our programmatic opportunity isn't integrations — it's use cases by industry. Someone searches 'inventory management for restaurants' or 'inventory tracking for Shopify.' Let's build pages for those."

**Why it matters:**

Programmatic SEO creates leverage only when there's genuine search demand for the variations. Creating thousands of pages that no one searches for is expensive (engineering, design, content) and worthless. The strategy must match your users' actual search behavior, not mimic another company's approach.
