---
title: Programmatic SEO Requires Real Search Demand
impact: HIGH
tags: programmatic, validation, scale
---

## Programmatic SEO Requires Real Search Demand

Creating thousands of pages at scale is only valuable if users search for those variations. Scale without demand is expensive noise.

**Incorrect (scale for scale's sake):**

> **Programmatic SEO Plan:**
>
> "We can generate 50,000 pages by combining:
> - Every city in America (30,000)
> - Every service category (50)
> - Every year (2020-2025)
>
> Pages like: 'Best Plumbers in Topeka, Kansas 2024'
>
> More pages = more surface area = more traffic!"
>
> *Result:* 50,000 thin pages that:
> - Have no unique content (same template, different city name)
> - Target searches that don't exist (no one searches "best plumbers in [small town] 2024")
> - Get flagged by Google as spam
> - Tank the site's overall authority

**Correct (validated programmatic):**

> **Programmatic SEO Plan:**
>
> "Before building, let's validate demand:
>
> 1. **Check search volume**: Are people searching '[service] in [city]'?
> 2. **Analyze patterns**: Which cities have enough population to generate searches?
> 3. **Look at competitors**: Where does TripAdvisor/Zillow/Yelp have pages that rank?
>
> Findings:
> - Only cities above 100,000 population have meaningful search volume
> - Year variations don't matter — remove those
> - We need unique content per page (local data, reviews, specifics)
>
> Revised plan: 500 pages for major cities with unique local data, not 50,000 thin pages."

**Why it matters:**

Google's spam algorithms specifically target thin, scaled content. More important: even if Google didn't penalize it, pages no one searches for generate zero value. The power of programmatic SEO is leverage — build once, capture many searches. But there must be searches to capture.
