---
title: SEO Requires Product Resources, Not Just Writers
impact: HIGH
tags: product, resources, teams
---

## SEO Requires Product Resources, Not Just Writers

SEO is not a marketing-only function. Building effective SEO experiences requires product managers, designers, and engineers — not just content writers.

**Incorrect (SEO as content production):**

> **SEO Team Structure:**
>
> "We've hired a content agency to handle SEO. They'll write 30 blog posts per month, optimize them for keywords, and we'll rank.
>
> Resources allocated:
> - Content agency: $10,000/month
> - SEO tool subscriptions: $500/month
>
> No PM involvement needed — this is a marketing activity."
>
> *Result:* 200 blog posts later, traffic is up but conversions are flat. The content doesn't integrate with the product. There's no interactive experience, no templates, no tools. Users read and leave.

**Correct (SEO as product development):**

> **SEO Team Structure:**
>
> "We're building SEO as a product. Here's what we need:
>
> - **PM**: Defines the user experience, prioritizes pages, sets success metrics
> - **Design**: Creates the page templates, ensures consistent experience
> - **Engineering**: Builds the infrastructure, handles programmatic generation
> - **Content**: Provides the expertise and writing where needed
>
> Our first project: Interactive templates users can customize. This isn't a blog post — it's a product feature that happens to be discoverable via search."
>
> *Result:* Templates generate 10x the conversions of blog posts because they provide immediate value and naturally lead to product signup.

**Why it matters:**

The most successful SEO strategies (Zapier, Zillow, TripAdvisor) built products for search users, not just content. You can't build these experiences with just writers. You need the same resources you'd use for any product feature: PM to define it, design to make it useful, engineering to build it.
