# Product-Led SEO Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Framework: SEO as Product

### The Three Steps

**Step 1: Understand the User**

Before any SEO work, answer: "What is someone going to search for that would make them want my product?"

If you can't answer this, don't do SEO.

> "I find very often when I talk to SaaS companies, I don't think SaaS in general should do SEO... Very often they have created a product for whatever user, and then the marketers are expected to make that product fit into the thing that the search results are around. And it doesn't work because that's not what they're looking for." — Eli Schwartz

**Step 2: Design the Asset**

What product experience does this searcher need? This isn't "what content should we write" — it's "what should we build?"

Options include:
- **Programmatic pages**: Data-driven pages at scale (Zillow, TripAdvisor, Zapier)
- **Editorial content**: Long-form content for complex, nuanced topics
- **Tools and templates**: Interactive experiences that solve immediate needs

**Step 3: Build Like a Product**

SEO requires the same resources as product development:
- Product manager to oversee the build
- Design resources for the experience
- Engineering for implementation
- User research to validate assumptions

> "The inputs for SEO aren't the way many people think of SEO, which is a piece of content optimized for Google based on the keywords I've chosen. I think of it as a product, which means you need design resources. You need engineering resources." — Eli Schwartz

## Programmatic vs Editorial SEO

### Programmatic SEO

Build data-driven pages at scale when:
- There's genuine search demand for variations (cities, products, combinations)
- You have unique data to power the pages
- Each page solves a real user problem

**Examples that work:**
- **Zapier**: Integration pages (Gmail + Salesforce) — users search for these combinations
- **Zillow**: Property pages — users search for specific addresses
- **TripAdvisor**: Hotel/city pages — users search for specific destinations

**Why they work:** Each page answers a real search query with genuine utility.

### Editorial SEO

Write long-form content when:
- The topic requires nuance and expertise
- You're building thought leadership
- The content supports a conversion path

**When to avoid editorial:**
- Writing content "because competitors have blogs"
- Topics that don't connect to your product's value
- Content written by non-experts rewriting each other

## The Funnel Shift: Top to Mid

### The AI Overview Problem

AI Overviews (and LLM search) are disrupting top-of-funnel SEO. Google now gives answers directly:

```
BEFORE AI OVERVIEWS:
User searches "best CRM tools" → Clicks your listicle → Learns about your product

AFTER AI OVERVIEWS:
User searches "best CRM tools" → Google gives the answer → User never clicks
```

**The strategic response:** Move to mid-funnel where intent is concrete.

### Top-of-Funnel (Being Disrupted)

- General information queries ("What is a CRM?")
- Listicles and comparisons ("Best CRM tools 2024")
- Educational content ("How to choose a CRM")

AI Overviews can answer these directly. Your content becomes input to Google's answer, not a destination.

### Mid-Funnel (The Opportunity)

- Specific solution queries ("Salesforce vs HubSpot pricing")
- Use-case searches ("CRM for real estate agents")
- Problem-aware queries ("How to track leads in Excel" → maybe they need a CRM)

**Example — Tinder:**

> "We discovered that Tinder is a loneliness-solving solution. You're lonely, you've gone to a new city, you don't know anybody... So we built pages for online dating in many cities around the world. AI Overviews might tell you what the dating scene is like... However, it doesn't allow you to solve the loneliness problem you have. The loneliness problem is a mid or bottom-of-funnel problem." — Eli Schwartz

## Should You Do SEO?

### The Decision Framework

Ask these questions:

1. **Is there an SEO journey?**
   - Do users search for your solution?
   - Would they convert from a search result?
   - Or is the buying process committee-driven?

2. **What's the alternative?**
   - What would you spend on paid marketing?
   - What's the trade show / event opportunity?
   - What's the influencer / brand marketing ROI?

3. **What's the full cost?**
   - SEO is not free: PM time, engineering, design, content, tools
   - $120K+/year for a serious SEO effort
   - Months to years before meaningful results

### Who Should NOT Do SEO

| Business Type | Why SEO Doesn't Work |
|---------------|---------------------|
| Enterprise SaaS | Committee decisions don't convert from search |
| Google Cloud, Salesforce | Brand drives the sale, not keyword rankings |
| Local services (plumbers, etc.) | Google Maps dominates; traditional SEO adds little |
| Products requiring integration | Too much friction to convert from a search click |
| New categories | No one searches for what doesn't exist yet |

### Who SHOULD Do SEO

| Business Type | Why SEO Works |
|---------------|--------------|
| Freemium SaaS | Search → try free → upgrade (SurveyMonkey model) |
| E-commerce | Search → buy (clear conversion path) |
| Marketplace aggregators | Programmatic pages at scale (Zillow, TripAdvisor) |
| Tools with specific use cases | Integration/template pages (Zapier, Canva) |
| Self-serve B2B | Low-friction conversion possible |

## AEO: Answer Engine Optimization

### What's Changing

LLMs (ChatGPT, Claude, Perplexity) and Google's AI Mode are changing search:

- **Traditional SEO**: Rank for keywords → get clicks → convert
- **AEO**: Get cited in answers → get mentioned as a solution → influence decisions

### How to Win at AEO

Based on Ethan Smith's framework:

1. **Identify target questions** (not just keywords)
2. **Track your share of voice** in LLM answers
3. **Optimize citations**: Reddit, YouTube, affiliate sites
4. **Answer follow-up questions** comprehensively
5. **Build brand mentions** across the web

### The Citation Strategy

In LLM search, showing up as a **brand** matters more than showing up as a **link**:

| Citation Type | Value |
|--------------|-------|
| Brand mention in answer | High — drives action |
| Source link clicked | Medium — if clickable |
| Content scraped, no attribution | Low — Google took your content |

> "Getting into the AI Overview, Google has links... If your link shows up there, then you likely were showing up beneath it in the ranking results, so you've already done the work you're supposed to do. If you're showing up as a brand... that means you've exercised brand efforts and it's working." — Eli Schwartz

## Common Mistakes

### 1. SEO by Default

"We raised money, so we need an SEO team" is not a strategy. SEO is a channel like any other — evaluate ROI before investing.

### 2. Traffic as Success Metric

Traffic without conversion is vanity. The only metrics that matter are business outcomes: MQLs, revenue, conversions.

### 3. Copying Competitors' Programmatic

Zapier's integration pages work because users search for "Gmail + Salesforce." If users don't search for your variations, scale creates nothing.

### 4. Content for Content's Sake

Writing blog posts because "competitors have blogs" is waste. Every piece of content needs a conversion path.

### 5. Link Building Theater

Guest posts on low-authority sites that no one reads don't help. Build brand and earn mentions naturally.

### 6. Ignoring the AI Shift

Top-of-funnel SEO is being eaten by AI Overviews. Adapt now by moving to mid-funnel and building brand.

## Application Checklists

### For Evaluating SEO Investment

- [ ] Is there search demand for our solution?
- [ ] Would users convert from a search result (vs. needing sales)?
- [ ] What's the full cost (PM, engineering, design, content)?
- [ ] How long before we see meaningful results?
- [ ] What's the alternative use of those resources?
- [ ] Have we validated the user journey, not just keyword volume?

### For Programmatic SEO

- [ ] Is there genuine search demand for variations?
- [ ] Do we have unique data to power these pages?
- [ ] Does each page solve a real user problem?
- [ ] Is this a product build (needing PM, design, engineering)?
- [ ] Have we validated search volume with real data (not just keyword tools)?

### For Content Strategy

- [ ] Does this content connect to our product's value?
- [ ] Is there a clear conversion path from this content?
- [ ] Are we writing from genuine expertise (not rewriting competitors)?
- [ ] Would this content survive AI Overviews (is it mid-funnel)?
- [ ] Are we measuring conversions, not just traffic?

### For AI Search (AEO)

- [ ] What questions (not keywords) do users ask about our space?
- [ ] Are we showing up in LLM answers as a brand?
- [ ] What citations are driving our visibility? (Reddit, YouTube, etc.)
- [ ] Do our pages answer follow-up questions comprehensively?
- [ ] Are we building brand mentions, not just links?

## Quick Reference

**The core idea:** SEO is a product discipline. Build experiences that serve searcher intent, not content optimized for keywords.

**The key question:** "Is there an SEO journey?" If users don't search for your solution and wouldn't convert from a search, don't do SEO.

**The funnel shift:** AI Overviews are eating top-of-funnel. Move to mid-funnel where intent is concrete and AI can't fully satisfy the need.

**The full cost:** SEO is not free. Count PM time, engineering, design, content, and tools. Compare to alternative investments.

**The success metric:** Not rankings, not traffic — business outcomes. MQLs, revenue, conversions.

---

