---
name: radical-candor
description: Use when asked to "radical candor", "give feedback that cares", "have a difficult conversation", "challenge directly", "manage performance issues", or "give praise that lands". Helps deliver direct feedback while showing you care. The Radical Candor framework (created by Kim Scott) teaches how to challenge directly while caring personally.
---

# Radical Candor

## What It Is

Radical Candor is a framework for giving feedback that builds trust and drives results. The core insight: **great feedback happens when you Care Personally AND Challenge Directly at the same time.**

Most people fail at feedback because they choose one or the other. They're either so focused on being nice that they don't say what needs to be said (ruinous empathy), or they're so focused on being direct that they forget to show they care (obnoxious aggression). Radical Candor isn't about finding a middle ground—it's about doing both fully.

The key shift: Move from "How do I deliver this feedback?" to "How do I help this person succeed?"

## When to Use It

Use Radical Candor when you need to:

- **Give feedback** (both praise and criticism) that actually lands
- **Have difficult performance conversations** with direct reports
- **Build a culture of honest communication** on your team
- **Solicit feedback** from others about your own performance
- **Coach employees** through growth and development
- **Address problems** before they become crises
- **Build trust** in professional relationships

## When Not to Use It

- **When you don't actually care** — if you just want to vent or hurt someone, that's obnoxious aggression with extra steps
- **When the feedback is about unchangeable personal traits** — focus on behavior, not personality
- **When you haven't solicited feedback first** — always start by asking for feedback before giving it
- **When you're saving it for a performance review** — Radical Candor happens in the moment, not quarterly
- **When you haven't built any relationship** — you need *some* foundation of care before challenging directly

## Patterns

Detailed examples showing how to apply Radical Candor correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [ruinous-empathy](patterns/ruinous-empathy.md) | Being "nice" by withholding feedback isn't kind—it's harmful |
| [obnoxious-aggression](patterns/obnoxious-aggression.md) | Challenging without caring puts people in fight-or-flight |
| [manipulative-insincerity](patterns/manipulative-insincerity.md) | Saying what people want to hear destroys trust |
| [soliciting-before-giving](patterns/soliciting-before-giving.md) | Always ask for feedback before you give it |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [feedback-sandwich](patterns/feedback-sandwich.md) | The praise-criticism-praise pattern backfires |
| [vague-praise](patterns/vague-praise.md) | "Great job!" teaches nothing—use CORE instead |
| [feedback-via-text](patterns/feedback-via-text.md) | Slack and email are feedback train wrecks waiting to happen |
| [waiting-for-better-moment](patterns/waiting-for-better-moment.md) | If you're waiting for the right time, you're never going to say it |
| [asking-why](patterns/asking-why.md) | "Why did you do that?" triggers defensiveness—ask about what happened instead |
| [personality-not-behavior](patterns/personality-not-behavior.md) | "You're disorganized" vs "The report was missing three sections" |
| [accepting-no-answer](patterns/accepting-no-answer.md) | Never accept "everything's fine" when soliciting feedback |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [gauging-how-it-lands](patterns/gauging-how-it-lands.md) | Watch for sad or mad—then adjust, don't retreat |
| [public-criticism](patterns/public-criticism.md) | Praise in public, criticize in private |
| [people-pleasing-trap](patterns/people-pleasing-trap.md) | Your job is to care, not to be liked |


## Deep Dives

Read only when you need extra detail.

- `references/radical-candor-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Radical Candor* by Kim Scott — the complete framework
- *Radical Respect* by Kim Scott — the prequel on building respectful workplaces
- *When They Win, You Win* by Russ Laraway — deep dive on career conversations

**Other:**
- radicalcandor.com — tools, workshops, and additional resources
- The Radical Candor podcast — ongoing examples and coaching
