# Radical Candor Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Framework: Two Dimensions

Radical Candor is defined by two dimensions that work together:

```
                        CARE PERSONALLY
                              |
                              |
         Ruinous         ────────────         Radical
         Empathy              |               Candor
                              |
    ──────────────────────────┼──────────────────────────
                              |
     Manipulative        ────────────        Obnoxious
     Insincerity              |              Aggression
                              |
                              |
                       CHALLENGE DIRECTLY
```

### Care Personally

This isn't about being friends or being "nice." It's about genuinely giving a damn about the person as a human being, not just as an employee.

What it looks like:
- Knowing what motivates them and what they want for their careers
- Helping when life gets hard (sick family, personal struggles)
- Treating them as a whole person, not just a role
- Taking the time to understand their perspective

### Challenge Directly

This isn't about being brutal or aggressive. It's about being clear and specific about what you observe and what needs to change.

What it looks like:
- Saying the hard thing that everyone's thinking
- Being specific about problems, not vague
- Not sugarcoating or hedging
- Following up until you've actually communicated

## The Four Quadrants

When you fail on either dimension, you land in one of three failure modes:

### Radical Candor (Care + Challenge)
You care about the person AND you tell them what they need to hear. This is the goal.

**Example:** "I know how much you care about this project. When you said 'um' every third word in that presentation, it undermined your credibility. I'd like to connect you with a speaking coach—I think it would make a real difference."

### Ruinous Empathy (Care without Challenge)
You care about the person SO MUCH that you don't tell them what they need to hear. This is the most common failure mode—90% of feedback mistakes fall here.

**Example:** "Oh Bob, this is such a great start. You're so awesome. We all love working with you. Maybe you can make it just a little bit better."

Result: 10 months later, you fire Bob. He asks, "Why didn't anyone tell me?"

### Obnoxious Aggression (Challenge without Care)
You tell them what you think, but you've forgotten (or don't care) about showing that you care. People go into fight-or-flight and can't hear what you're saying.

**Example:** Walking into a room and saying "In the spirit of Radical Candor, your work is garbage and you should be embarrassed."

Result: Inefficient (they can't hear you), harmful (you hurt them), and often leads to...

### Manipulative Insincerity (Neither Care nor Challenge)
You don't say what you really think AND you don't show that you care. Often where people land after they realize they've been obnoxiously aggressive.

**Example:** Telling someone their presentation was "fine" when it was actually terrible, because you're afraid of how they'll react.

Result: You've lied to avoid discomfort. Trust erodes. Problems fester.

## The Order of Operations

There's a sequence to practicing Radical Candor effectively:

### 1. Solicit Criticism First

Before you give feedback, you must ask for it. This accomplishes three things:
- Shows you're open to being challenged yourself
- Builds the relationship needed to give feedback
- Demonstrates that feedback is about improvement, not judgment

**How to ask:**
- NOT: "Do you have any feedback for me?" (They'll say "everything's fine")
- BETTER: "What could I do or stop doing that would make it easier to work with me?"
- ALSO GOOD: "What could I have done this week to better support you?"

**Critical steps:**
1. **Ask your question** — use words that sound like you, not a script
2. **Embrace the discomfort** — close your mouth and count to six
3. **Listen to understand, not respond** — don't get defensive
4. **Reward the candor** — fix the problem visibly, not just "thanks for the feedback"

### 2. Give More Praise Than Criticism

Radical Candor isn't all about criticism. Praise is actually MORE important because:
- It tells people what to do MORE of
- It builds the relationship capital needed for criticism
- Most people underestimate how much positive feedback matters

But the praise must be specific and meaningful (see CORE below).

### 3. Give Criticism in the Moment

Don't wait for the "right time." Don't save it for a one-on-one. Don't batch it for performance reviews.

If the purpose of criticism is to help someone do less of something, why wait?

The only exceptions:
- You're so upset you'll say it badly
- They're so upset they can't hear you

## The HHIIPP Framework for Delivering Feedback

Whether giving praise or criticism, follow these principles:

| Principle | What It Means |
|-----------|---------------|
| **Humble** | You might be wrong. This is candor, not truth. |
| **Helpful** | State your intention to help, not to dominate. |
| **Immediate** | Say it right away. "I'll wait for a better moment" means never. |
| **In-person** | Synchronous communication. Phone beats video. Never via Slack/email. |
| **Private (criticism)** | Criticism in private. Always. |
| **Public (praise)** | Praise in public when appropriate. |
| **Not about Personality** | Focus on behavior, not character traits. |

## The CORE Framework for Specific Feedback

Both praise and criticism should follow CORE:

| Element | What It Is | Example (Praise) | Example (Criticism) |
|---------|-----------|------------------|---------------------|
| **C**ontext | The situation | "In the meeting..." | "In the meeting..." |
| **O**bservation | What you observed | "...when you presented both sides of the argument..." | "...when you said 'um' every third word..." |
| **R**esult | The impact | "...it earned you credibility with the team." | "...it made you sound unsure of yourself." |
| **E** (Next Step) | What to do | "Keep doing that." | "Would you like to work with a speaking coach?" |

**Why CORE matters:** Vague feedback like "great job!" or "you need to improve" teaches nothing. CORE tells people exactly what to do more of or less of.

## Soliciting Feedback: The Detailed Process

### Step 1: Craft Your Go-To Question

Write down the exact words you'll use. Practice them. Make them sound like you.

Bad questions:
- "Do you have any feedback for me?"
- "Is everything okay?"
- "Any thoughts?"

Better questions:
- "What could I do or stop doing that would make it easier to work with me?"
- "Tell me why I'm wrong."
- "What's one way I could have better supported you this week?"

### Step 2: Embrace the Discomfort

After you ask, close your mouth and count to six. Six seconds is uncomfortable, but almost no one can endure that much silence—they'll tell you something.

### Step 3: Listen to Understand

You'll probably feel defensive. That's normal. Don't let it shut you down.

Ask follow-up questions to make sure you understand:
- "Can you give me an example?"
- "Tell me more about that."
- "What would that look like?"

### Step 4: Reward the Candor

If you agree:
- Fix the problem visibly
- Tell people who told you: "So-and-so mentioned X, so we changed Y"
- Ask if you over-corrected or under-corrected

If you disagree:
- Find the 5-10% you CAN agree with
- Say "I want to think about the rest and get back to you"
- Actually get back to them with a respectful explanation

### Step 5: Never Accept "Everything's Fine"

If someone says they have no feedback, say: "I know I'm not perfect. I'd really value hearing something. Notice something this week and let's talk next time."

## Common Mistakes

### 1. Thinking Radical Candor means being a jerk
"In the spirit of Radical Candor..." followed by cruel criticism is obnoxious aggression. Radical Candor requires BOTH caring AND challenging.

### 2. Avoiding criticism because you want to be liked
Your job is not to be liked. Your job is to care about people. Sometimes caring means telling them something they don't want to hear.

### 3. Giving feedback via Slack, email, or text
You cannot gauge how feedback is landing through text. Pick up the phone. Have the conversation synchronously.

### 4. Saving feedback for one-on-ones or performance reviews
Feedback should be given immediately. Saving it means you forget details, and the moment for learning passes.

### 5. Using the feedback sandwich
Praise-criticism-praise trains people to distrust your praise. Be direct instead.

### 6. Thinking criticism is Radical Candor
Praise is actually MORE important than criticism. It tells people what to do more of and builds the relationship.

### 7. Failing to solicit feedback first
You cannot give feedback effectively until you've demonstrated you can receive it. Start by asking.

## Application Checklists

### For Managers: Weekly Feedback Habit

- [ ] Did I solicit feedback from each direct report this week?
- [ ] Did I give specific praise (using CORE) to each person who deserved it?
- [ ] Did I address problems immediately rather than saving them?
- [ ] Did I have feedback conversations synchronously (not via text)?
- [ ] Did I follow up on feedback I received to show I took it seriously?

### For Difficult Conversations

- [ ] Have I solicited feedback from this person recently?
- [ ] Am I giving this feedback to help them, or to make myself feel better?
- [ ] Can I describe the specific behavior (not personality trait)?
- [ ] Am I prepared to gauge their reaction and adjust?
- [ ] Am I doing this synchronously and privately?

### For Building a Candor Culture

- [ ] Do I publicly ask for feedback on myself?
- [ ] Do I visibly act on feedback I receive?
- [ ] Do I praise people publicly for giving candid feedback?
- [ ] Do I give feedback immediately rather than batching it?
- [ ] Do I give more praise than criticism?

### For Career Conversations (Showing You Care)

Have three separate 45-minute conversations:
- [ ] **Past:** What motivates them? What shaped their career?
- [ ] **Future:** What do they want at the height of their career? (3-4 different pictures)
- [ ] **Action Plan:** What skills should they develop? Who can you introduce them to?

## The Bob Story: Why Ruinous Empathy Is the Real Enemy

Kim Scott's most famous example of ruinous empathy:

Bob was smart, charming, and beloved by the team. But his work was consistently sloppy. Every time he handed in work with shame in his eyes, Kim would say: "Oh Bob, this is such a great start. You're so awesome. Maybe make it just a little bit better."

This went on for 10 months.

Eventually, Kim had to fire Bob. When she told him, he looked her in the eye and asked: "Why didn't you tell me? I thought you all cared about me."

Being "nice" for 10 months meant firing him at the end. Not so nice after all.

**The lesson:** It's not kind to withhold feedback. It's cruel. If you care about someone, you tell them what they need to hear to succeed.

## Quick Reference

**The core idea:** Care Personally + Challenge Directly. Do both fully.

**The most common mistake:** Ruinous Empathy (caring so much you don't challenge).

**The order of operations:** Solicit feedback first. Give more praise than criticism. Give criticism immediately.

**How to deliver:** HHIIPP (Humble, Helpful, Immediate, In-person, Private criticism, Public praise, not Personality)

**How to be specific:** CORE (Context, Observation, Result, nExt step)

**How to solicit:** Ask a specific question. Count to six. Listen to understand. Reward the candor.

---

