---
name: seven-powers
description: Use when asked to "7 Powers", "build a competitive moat", "analyze defensibility", "find sustainable advantage", "economic moats", or "Hamilton Helmer framework". Helps identify durable competitive advantages. The 7 Powers framework (created by Hamilton Helmer) reveals the economic structures that protect business value from competition.
---

# 7 Powers: The Foundations of Business Strategy

## What It Is

7 Powers is a framework for understanding sustainable competitive advantage. The core insight: **Business value comes from possessing an attribute that produces higher returns than competitors AND a barrier that prevents competitors from arbitraging it away.**

Power = Benefit + Barrier

Warren Buffett famously said: "In business, I look for economic castles protected by unbreachable moats." Power is understanding what makes something a castle (the benefit) versus a shack, and what makes the moat unbreachable (the barrier).

The key shift: Move from asking "What's our competitive advantage?" to asking "What economic structure creates durable differential returns?"

## When to Use It

Use 7 Powers when you need to:

- **Evaluate a business's long-term defensibility** (investment decisions, competitive analysis)
- **Design a startup for durability** (not just product-market fit)
- **Understand why incumbents can't respond** to your disruptive move
- **Prioritize strategic initiatives** based on what builds power
- **Identify whether you actually have a moat** or just operational excellence
- **Plan second acts** (new business lines that could develop power)
- **Win market share battles** in high-growth phases

## When Not to Use It

- You don't have product-market fit yet (but DO think about which path tilts toward power)
- The business is purely commodity with no differentiation possible
- You want to justify a strategy you've already decided on (intellectual honesty required)
- You're optimizing operations (power is about structure, not execution)

## Patterns

Detailed examples showing how to apply 7 Powers correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [operational-excellence-not-power](patterns/operational-excellence-not-power.md) | Running faster on a treadmill isn't power — it can be mimicked |
| [benefit-without-barrier](patterns/benefit-without-barrier.md) | A castle without a moat gets stormed |
| [network-effects-vs-network-economies](patterns/network-effects-vs-network-economies.md) | Having network effects doesn't mean you have power |
| [power-timing](patterns/power-timing.md) | Different powers are available at different business stages |
| [counter-positioning-window](patterns/counter-positioning-window.md) | Counter-positioning is your refuge from incumbents — but only early |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [scale-economies-data](patterns/scale-economies-data.md) | Data advantages flatten faster than you think |
| [flywheel-materiality](patterns/flywheel-materiality.md) | Every startup claims a flywheel — few have material ones |
| [branding-vs-brand-recognition](patterns/branding-vs-brand-recognition.md) | Buying ads doesn't create branding power |
| [switching-costs-that-stick](patterns/switching-costs-that-stick.md) | Not all switching costs are durable |
| [geographic-specificity](patterns/geographic-specificity.md) | Some powers are local, not global |
| [war-of-attrition](patterns/war-of-attrition.md) | Modest scale economies can win through patience |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [process-power-opacity](patterns/process-power-opacity.md) | Process power requires complexity that can't be copied |
| [cornered-resource-scope](patterns/cornered-resource-scope.md) | Cornered resources must transfer value to work |
| [second-acts](patterns/second-acts.md) | Iconic companies often build new power later |


## Deep Dives

Read only when you need extra detail.

- `references/seven-powers-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *7 Powers* by Hamilton Helmer — the complete framework
- *Good Strategy Bad Strategy* by Richard Rumelt — complementary perspective on strategy
- *Competition Demystified* by Bruce Greenwald — value investing lens on competitive advantage

**Related Concepts:**
- Porter's Five Forces — industry structure analysis (complements 7 Powers)
- Warren Buffett's Letters — practical examples of moat thinking
- "Aggregation Theory" by Ben Thompson — modern application of scale and network power

**Credit:** This skill is based on Hamilton Helmer's book *7 Powers: The Foundations of Business Strategy* and his teachings at Netflix, Stanford, and his work with Strategy Capital.
