---
title: Cornered Resources Must Transfer Value
impact: MEDIUM
tags: cornered-resource, assets, transfer-test
---

## Cornered Resources Must Transfer Value

A Cornered Resource is an asset that provides value and that you have exclusive access to. The key test: Would this resource be valuable if transferred to a competitor? If not, it's not a cornered resource — it's just something you happen to have.

**Incorrect (claiming any unique asset as cornered resource):**

> **Investor Presentation:**
>
> "Our cornered resources include:
> - Our founding team's unique combination of skills
> - 5 years of customer usage data
> - Relationships with key enterprise accounts
> - Our proprietary codebase
>
> These resources can't be replicated, giving us durable advantage."

**Correct (applying the transfer test):**

> **Investor Presentation:**
>
> "Let's apply the transfer test to each claimed resource:
>
> **1. Founding team skills**
> - Transfer test: Would our founders be uniquely valuable at a competitor?
> - Analysis: Domain expertise could be valuable, but most skills are replicable
> - Verdict: Not a cornered resource (can be approximated by hiring)
>
> **2. Customer usage data**
> - Transfer test: Would this data be valuable to a competitor?
> - Analysis: Only if it can't be collected independently. Competitors can collect similar data over time.
> - Verdict: Maybe temporal advantage, not cornered resource
>
> **3. Enterprise relationships**
> - Transfer test: Could we 'transfer' these relationships?
> - Analysis: Relationships are with individuals, not transferable assets
> - Verdict: Not a cornered resource (depends on people, not asset)
>
> **4. Proprietary codebase**
> - Transfer test: Would our code be valuable to a competitor?
> - Analysis: They could rebuild similar functionality
> - Verdict: Not a cornered resource (replicable)
>
> **What WOULD be a cornered resource:**
> - Patent on key technology (legal exclusivity)
> - Exclusive content licensing deal (contractual exclusivity)
> - Mineral rights to a rare deposit (physical exclusivity)
> - Regulatory license that can't be replicated (government exclusivity)
>
> **Our assessment:** We don't currently have a cornered resource. Our advantages come from other sources (scale economies, switching costs)."

**The Transfer Test:**

Ask: "If I gave this resource to a competitor, would it be valuable to them AND would they not be able to get it otherwise?"

| Resource Type | Transfer Test Result | Cornered Resource? |
|---------------|---------------------|-------------------|
| Pharmaceutical patent | Yes — competitor could sell the drug | Yes |
| Exclusive celebrity partnership | Yes — competitor could use celebrity | Yes |
| "Great engineering team" | No — competitors can hire engineers | No |
| "5 years of data" | Maybe — depends if replicable | Usually no |
| Mining rights | Yes — anyone could extract ore | Yes |
| Customer relationships | No — relationships don't transfer | No |

**Why cornered resources are rare in tech:**

Most tech "resources" fail the transfer test:
- **Talent:** Can be recruited by competitors
- **Code:** Can be rebuilt
- **Data:** Can be collected over time
- **Relationships:** Depend on people, not assets

True cornered resources in tech usually involve:
- **Patents:** Legal protection (though often narrow)
- **Exclusive content deals:** Contractual exclusivity
- **Regulatory licenses:** Government protection
- **Network effects that create exclusive access:** Very rare

**Why it matters:**

Claiming "cornered resource" for assets that don't pass the transfer test dilutes your strategic thinking. Be rigorous: Would a competitor pay to acquire this asset? Could they get equivalent value by other means? If yes to the second question, it's not cornered.
