---
title: The Counter-Positioning Window Closes
impact: CRITICAL
tags: counter-positioning, timing, incumbents, startups
---

## The Counter-Positioning Window Closes

Counter-positioning is a startup's primary refuge from incumbents — they can't copy you without damaging themselves. But this window closes. Once you're large enough to be an existential threat, incumbents may rationally decide to cannibalize themselves. By then, you need other powers.

**Incorrect (relying on counter-positioning indefinitely):**

> **Board Strategy Discussion (Year 5, $100M ARR):**
>
> "Our competitive moat remains our business model. Incumbents still can't offer our freemium model without destroying their enterprise sales motion. We're protected."
>
> **3 years later:** Major incumbent launches free tier, invests heavily in bottom-up growth, accepts short-term revenue hit. Startup's growth stalls.

**Correct (planning the transition):**

> **Board Strategy Discussion (Year 5, $100M ARR):**
>
> "Counter-positioning has served us well, but let's assess its durability:
>
> **Our counter-position:** Freemium model incumbents can't match without cannibalizing enterprise deals.
>
> **Status check:**
> - We now have 15% market share and growing
> - We're winning deals from their enterprise customers
> - Analysts are writing about us as an existential threat
>
> **Risk:** At this size, incumbents may rationally decide short-term pain is worth eliminating long-term threat. Counter-positioning is expiring.
>
> **Transition plan — what other powers are we building?**
> - Scale economies: Our infrastructure costs per user are now 40% lower than smaller competitors. Real but modest.
> - Switching costs: Customer workflows and integrations create real lock-in. Strong.
> - Network effects: Marketplace dynamics in our platform. Moderate, testing materiality.
>
> **Action:** Accelerate switching cost development. When the incumbent finally moves, our customers need to be locked in."

**Classic Example — Netflix vs Blockbuster:**

Blockbuster *could* have launched streaming, but didn't because:
- It would cannibalize store traffic (real estate costs were fixed)
- It would undermine the late-fee model (major profit center)
- Shareholders would revolt at declining near-term profits

By the time Blockbuster finally tried (2010), Netflix had 20M+ subscribers and massive scale economies in content licensing. The counter-positioning window had closed, and Netflix had other powers.

**Why it matters:**

Counter-positioning buys you time, not permanent protection. Use that time to build other powers. If you're still relying solely on "incumbents can't copy us" after 5+ years and significant market share, you're vulnerable.

Hamilton Helmer: "Counter-positioning is the refuge from [incumbents]... and then you go into the other three types of power — scale economies, switching costs and network economies."
