---
title: Every Startup Claims a Flywheel
impact: HIGH
tags: flywheel, network-effects, materiality
---

## Every Startup Claims a Flywheel

"We laugh whenever we hear somebody say they have a flywheel," Hamilton Helmer notes. The concept is so overused that it's nearly meaningless. Many flywheels exist — few are material enough to create power.

**Incorrect (claiming any reinforcing loop as power):**

> **Pitch Deck — Our Flywheel:**
>
> ```
> More Users → More Data → Better Product → More Users
> ```
>
> "Our flywheel creates compounding advantage. Each new user makes the product better, attracting more users. This virtuous cycle makes us increasingly defensible."

Every software company can draw this diagram. It doesn't mean anything without materiality testing.

**Correct (testing flywheel materiality):**

> **Strategic Analysis — Flywheel Assessment:**
>
> "We have a reinforcing loop. Let's test if it creates power:
>
> **The claimed flywheel:**
> More Users → More Data → Better Recommendations → More Users
>
> **Materiality test at each step:**
>
> 1. **More Users → More Data:** Yes, linear relationship
>
> 2. **More Data → Better Recommendations:**
>    - Tested: 10x more data = 5% better recommendations
>    - Curve is flattening
>
> 3. **Better Recommendations → More Users:**
>    - Tested: 5% better recommendations = 2% higher conversion
>    - Small effect
>
> **Full loop multiplier:**
> 2x users → 2x data → ~3% better recs → ~1% more users
>
> **Conclusion:** The flywheel exists but isn't material. A 2x user advantage yields only ~1% more growth. This is a feature, not a moat.
>
> **For comparison — a MATERIAL flywheel (Amazon Marketplace):**
> - More sellers → more selection → more buyers → more sellers
> - Each doubling of sellers meaningfully increases buyer value
> - Buyers strongly prefer the marketplace with more sellers
> - Sellers strongly prefer the marketplace with more buyers
> - The flywheel IS the defensibility"

**Signs your flywheel isn't material:**

| Weak Flywheel Signs | Strong Flywheel Signs |
|---------------------|----------------------|
| Competitors thrive at smaller scale | Competitors struggle below scale threshold |
| Price competition remains fierce | You have pricing power |
| Customer acquisition costs similar to competitors | Your CAC drops while competitors' rises |
| Growth requires proportional investment | Growth becomes self-sustaining |

**Why it matters:**

The existence of a reinforcing loop doesn't mean power. Power requires that the loop produce *material* benefits — large enough to sustain meaningful cost or price advantages. Most claimed flywheels, when tested rigorously, produce single-digit percentage improvements. That's nice optimization, not a moat.
