---
title: Some Powers Are Local, Not Global
impact: HIGH
tags: scale-economies, geographic, market-definition
---

## Some Powers Are Local, Not Global

Not all scale economies are global. Some businesses have geographically specific power — being strong in San Francisco doesn't help you in London. Misdefinining your market geography leads to wasted expansion and false confidence.

**Incorrect (assuming global scale economics):**

> **Uber's Original Premise (pre-2017):**
>
> "We're building a global transportation network:
> - Scale economies in technology development spread across all markets
> - Brand recognition transfers internationally
> - Learnings from one city apply everywhere
>
> Winning in the US helps us win in China, Europe, and India."

Uber spent billions on this thesis before retreating from China (sold to Didi), Russia (sold to Yandex), and Southeast Asia (sold to Grab).

**Correct (understanding geographic specificity):**

> **Corrected Strategic Analysis:**
>
> "Let's examine which advantages transfer geographically:
>
> **What transfers globally:**
> - Technology platform development costs (amortizable)
> - Some operational learnings
> - Investor relationships
>
> **What doesn't transfer:**
> - Driver supply (local)
> - Rider demand (local)
> - Regulatory relationships (local)
> - Local operational density (hyperlocal)
> - Brand recognition (regional at best)
>
> **Implication:** Our scale economies are primarily geographic:
> - Having 80% share in SF means lower driver acquisition costs in SF
> - Having 80% share in SF means nothing for driver costs in London
>
> **Strategic shift:**
> - Define power market-by-market, not globally
> - A great position in NYC doesn't protect us in LA
> - International expansion requires rebuilding power from scratch
>
> **Where global scale DOES help:**
> - Platform/app development (genuine global scale economy)
> - But this is a small % of total costs vs local operations"

**Hamilton Helmer on Uber:** "They made one initial misstep, which is they misdefined their business. They said it was international transportation and it's not. That business is extremely geographically specific. If you have a great position in the Bay Area, it doesn't help you in London."

**Testing geographic specificity:**

| Question | If "Local" | If "Global" |
|----------|-----------|-------------|
| Does my scale in Market A lower costs in Market B? | No | Yes |
| Do customers in Market B value my share in Market A? | No | Yes |
| Can I use Market A resources to serve Market B? | No | Yes |

**Examples:**

| Business | Scale Economics |
|----------|-----------------|
| Netflix content | Global (same content serves all markets) |
| Uber driver supply | Local (drivers in NYC don't help in LA) |
| AWS infrastructure | Global (same servers serve everyone) |
| DoorDash restaurants | Local (restaurant network is city-specific) |
| Google Search | Global (same algorithm serves all) |

**Why it matters:**

Misdefinining your power geography leads to either:
1. **False confidence:** "We have scale!" when you have local scale that doesn't transfer
2. **Wasted expansion:** Entering markets where your existing power doesn't help

Always ask: "Does our scale advantage in Market A translate to lower costs or higher value in Market B?" If not, you need separate power strategies for each geography.
