---
title: Network Effects vs Network Economies
impact: CRITICAL
tags: network-effects, materiality, common-mistake
---

## Network Effects vs Network Economies

Every startup with a marketplace or platform claims "network effects." But network effects are common; network *economies* (actual power) are rare. The difference is materiality — whether the network effect creates significant enough value to sustain price differentials.

**Incorrect (claiming network effects as power):**

> **Pitch Deck — Competitive Moat:**
>
> "We have powerful network effects:
> - More drivers = shorter wait times for riders
> - More riders = more demand for drivers
> - This creates a flywheel that becomes unbeatable at scale
>
> Our network effects make us defensible against competitors."

**Correct (testing for network economies):**

> **Strategic Analysis:**
>
> "We have network effects, but do we have network economies? Let's test materiality:
>
> **The question:** Does having 30% more drivers than a competitor allow us to charge meaningfully higher prices?
>
> **The test:**
> - Lyft has ~30% market share vs Uber's ~70% in most US markets
> - Wait times differ by 1-2 minutes on average
> - Price difference: Roughly equivalent (Lyft often cheaper to compete)
>
> **Conclusion:** Network effects exist but aren't material enough to create network economies. Both companies compete primarily on price/promotions, not on network value. Neither can sustain premium pricing.
>
> **Contrast with LinkedIn:**
> - LinkedIn's professional network is uniquely valuable (your professional contacts are there)
> - A new professional network with 10% of LinkedIn's users offers dramatically less value
> - LinkedIn can charge premium prices for recruiter tools
> - Network effects ARE material — this IS network economies"

**The Uber/Lyft Lesson:**

Hamilton Helmer specifically addresses this: "I'd say that [Uber and Lyft] probably have network effects involved but not network economies... The advantage that they get, it's not material."

**Why it matters:**

Network effects are a mechanism; network economies are power. The mechanism must produce benefits large enough to sustain meaningful price or cost differences. Without materiality, you have a feature, not a moat.

**Quick test:** If a competitor had 30% fewer users than you, would customers pay you meaningfully more? If not, you don't have network economies.
