---
title: Power Has a Timeline
impact: CRITICAL
tags: power-progression, timing, startup-strategy
---

## Power Has a Timeline

Different types of power are available at different business stages. Trying to build the wrong power at the wrong time wastes resources and misses windows of opportunity.

**Incorrect (ignoring power timing):**

> **Early-Stage Startup Strategy Session:**
>
> "Our three-year power strategy:
> - Year 1: Build brand power through marketing campaigns
> - Year 2: Develop process power by creating proprietary methodologies
> - Year 3: Leverage switching costs from our large customer base
>
> This comprehensive approach ensures durable competitive advantage."

Problems:
- Branding power takes decades, not years, and requires stability
- Process power requires complexity that emerges over long periods
- Switching costs require customers you don't have yet
- No mention of counter-positioning (the startup's key early advantage)

**Correct (power progression):**

> **Early-Stage Startup Strategy Session:**
>
> "Our power strategy must match our stage:
>
> **Now (Origination):**
> - Focus: Counter-positioning — why can't incumbents copy us?
> - Our advantage: Incumbents would have to cannibalize their high-margin professional services to offer our self-serve model. They won't.
>
> **Next 2 years (Takeoff):**
> - Focus: Win the market share race to establish scale-based power
> - Target: Scale economies (spread our fixed platform costs over more users)
> - Target: Switching costs (build integrations that lock customers in)
>
> **Year 3+ (Stability, if we win):**
> - Consider: Can we develop branding power over time?
> - Consider: Will our processes become inimitable?
>
> **Off the table for now:**
> - Branding power (requires sustained market presence we don't have)
> - Process power (requires organizational complexity we don't have)
> - Cornered resource (we don't have unique assets)"

**The Power Progression:**

```
STAGE           AVAILABLE POWERS
────────────────────────────────────────────
Origination     Counter-Positioning (primary)
                Cornered Resource (if you have it)

Takeoff         Scale Economies
                Network Economies
                Switching Costs

Stability       Branding
                Process Power
```

**Why it matters:**

Hamilton Helmer: "There's a thing called power progression. There are times when certain types of power are available and the converse of that is times when they're not available."

An early startup claiming branding power is like claiming to have a 20-year track record on day one. Focus on what's actually available.
