---
title: Process Power Requires Opacity
impact: MEDIUM
tags: process-power, operational-excellence, rare
---

## Process Power Requires Opacity

Process Power is the rarest of the seven powers. It's not just operational excellence — it's operational excellence so embedded in organizational complexity and tacit knowledge that competitors cannot understand or replicate it, even when they try.

**Incorrect (claiming operational excellence as Process Power):**

> **Strategy Document:**
>
> "Our Process Power comes from:
> - Agile methodology refined over 8 years
> - Custom CI/CD pipeline with 95% automation
> - Engineering culture of documentation and code review
> - Sophisticated on-call rotation and incident response
>
> These processes give us a sustainable advantage competitors can't match."

Problems:
- Agile methodology is well-documented and teachable
- CI/CD pipelines are replicable (and many are open source)
- Engineering culture can be hired away
- None of this is opaque — consultants teach all of it

**Correct (testing for true Process Power):**

> **Strategy Document:**
>
> "Let's test our processes against Process Power criteria:
>
> **Test 1: Could a consultant teach this to a competitor?**
> - Our agile practices? Yes — McKinsey has playbooks
> - Our CI/CD? Yes — DevOps consultants do this
> - Our engineering culture? Partially — but key people can be hired
>
> **Conclusion:** Most of our operational excellence can be copied.
>
> **What WOULD qualify as Process Power:**
> - Something so complex it can't be documented
> - Something so distributed across people it can't be transferred
> - Something so tacit that even our employees can't fully explain it
>
> **Example: Toyota Production System**
> - Toyota published books explaining it
> - Allowed competitors to tour factories
> - Sent consultants to teach it
> - Competitors still couldn't replicate it for decades
>
> **Why?** The knowledge was embedded in thousands of small decisions, cultural norms, and worker behaviors that couldn't be extracted or transferred.
>
> **Our assessment:**
> - We have strong operational excellence (necessary)
> - We don't have Process Power (it's not opaque enough)
> - If there's a consulting firm that offers to teach this, it's not Process Power"

**The Toyota Test:**

Toyota's production system is the canonical example of Process Power. Despite:
- Published books (The Toyota Way, etc.)
- Factory tours for competitors
- Former employees at other companies
- Consultants trying to replicate it

...competitors struggled for decades to match Toyota's quality and efficiency. Why? The system was so embedded in organizational culture and tacit knowledge that it couldn't be extracted.

**Heuristic from Hamilton Helmer:** "If there isn't a consulting firm that offers to bring you up to speed on that practice, maybe it's Process Power. If there is, it's not."

**Where Process Power might exist:**

| Industry | Potential Process Power |
|----------|------------------------|
| Car manufacturing | Complex assembly optimization (Toyota) |
| Chip fabrication | Yield optimization (TSMC) |
| Animation studios | Creative process (Pixar, maybe) |
| Most software | Unlikely — processes are too transferable |

**Why it matters:**

Process Power is real but extremely rare. Most "process advantages" are operational excellence that can be copied by:
- Hiring consultants
- Recruiting employees from competitors
- Reading the same books and papers

Don't claim Process Power unless your processes truly can't be understood or replicated by determined competitors with resources.
