---
title: Iconic Companies Have Second Acts
impact: MEDIUM
tags: strategy, expansion, power-building
---

## Iconic Companies Have Second Acts

Many of the most successful companies didn't stop after their first product. They built entirely new businesses — often bigger than the original — using the power development process all over again. Recognizing second-act opportunities is critical for sustained growth.

**Incorrect (assuming one power source is enough):**

> **Strategic Planning Session:**
>
> "We've achieved strong market position with our core product:
> - 45% market share in our category
> - Strong scale economies in content production
> - High switching costs from customer integrations
>
> Strategy: Defend and optimize our core business. Adjacent opportunities are distractions."

**Correct (scanning for second acts):**

> **Strategic Planning Session:**
>
> "Our core business is strong. Let's examine second-act opportunities:
>
> **The pattern we're looking for:**
> - New business that can develop independent power
> - Leverage from existing capabilities but not dependent on them
> - Large enough market to matter
>
> **Historical examples:**
>
> | Company | First Act | Second Act | Second Act Power |
> |---------|-----------|------------|------------------|
> | Amazon | E-commerce | AWS | Scale economies (infrastructure), switching costs |
> | Apple | Computers | iPhone | Ecosystem lock-in, branding, scale economies |
> | Intel | Memory chips | Microprocessors | Scale economies, counter-positioning |
> | Google | Search | Android/YouTube | Network effects, scale economies |
>
> **What made these work:**
> - Not just extensions of core business
> - Developed their own power sources
> - Often started as small experiments
>
> **Our opportunities:**
> - Adjacent market A: Could develop network effects (investigate)
> - Adjacent market B: Leverages our content but needs own power
> - Platform play: Could create switching costs with third-party developers
>
> **Process:**
> 1. Explore opportunities without betting the company
> 2. Test for potential power development
> 3. If power path exists, invest to win that market
> 4. Treat it as a new startup — it needs its own power strategy"

**The AWS Example:**

Amazon Web Services started as internal infrastructure. Key insights:
- Entirely different business from e-commerce
- Developed its own power: scale economies (spreading massive infrastructure costs)
- Counter-positioned against traditional IT vendors
- Now larger market cap contribution than retail

**The Intel Example:**

Intel's transition from memory to microprocessors:
- Memory was becoming commoditized
- Microprocessors offered new power opportunity
- Counter-positioned against vertical integration (IBM making own chips)
- Scale economies became dominant

**Questions to identify second-act opportunities:**

1. **What capabilities do we have that could serve different markets?**
2. **Where do we see emerging technology shifts that favor our position?**
3. **What adjacent problems do our customers have that aren't well-served?**
4. **Could we develop counter-positioning against different incumbents?**
5. **Is there a platform play that would create new network effects?**

**Why it matters:**

Hamilton Helmer notes: "Another thing that's quite surprising about iconic businesses is they often have a second act or a third act or fourth act... And that's actually common, not unusual, and that's starting the process all over again."

Don't assume your first power source is your only opportunity. The most valuable companies continuously develop new power in new arenas.
