---
title: Winning Wars of Attrition
impact: HIGH
tags: scale-economies, competition, patience, strategy
---

## Winning Wars of Attrition

Even modest scale economies can win if played with patience. When scale advantages are real but small, the path to victory is a long war of attrition — gradually expanding your advantage while competitors bleed.

**Incorrect (expecting quick knockout):**

> **Competitive Strategy Review:**
>
> "Analysis shows our scale economics give us a 15% cost advantage per ride:
> - We should be able to eliminate Lyft within 2 years
> - Our superior economics make victory inevitable
> - Recommend aggressive pricing to accelerate their exit
>
> Expected outcome: Market consolidation by 2020."

This underestimates competitor resilience and overestimates the power of modest advantages.

**Correct (planning for attrition):**

> **Competitive Strategy Review:**
>
> "Our scale advantages are real but modest:
>
> **Current position:**
> - ~70% market share vs Lyft's ~30%
> - Estimated cost advantage: 10-15% per ride (geographic density, driver utilization)
> - Not enough to sustain knockout blow — Lyft can survive by matching prices
>
> **War of attrition strategy:**
>
> 1. **Accept the timeline:** This is a 5-10 year contest, not a 2-year blitz
>
> 2. **Expand the advantage incrementally:**
>    - Uber Eats creates more driver hours (spreads fixed costs)
>    - Each additional service widens the platform advantage
>    - Compound small advantages over time
>
> 3. **Focus on sustainable moves:**
>    - Don't burn cash on unsustainable promotions
>    - Invest in structural advantages (platform, density, utilization)
>    - Let modest advantages compound
>
> 4. **Patience as strategy:**
>    - Lyft will gradually struggle to match investment
>    - Their smaller scale means less platform diversification opportunity
>    - Time is on our side — we can wait them out
>
> **Key insight:** Modest scale economies win through patience, not aggression."

**The Uber vs Lyft Story:**

Hamilton Helmer: "I'd say [Uber's success vs Lyft] was a well-played war of attrition with modest scale economies."

Key moves:
- Uber correctly recognized geographic specificity (retreated from unwinnable international markets)
- Diversified into Uber Eats (leverages driver network for more occasions)
- Played for platform economics rather than quick victory
- Lyft is now ~5% of Uber's market cap despite similar technology

**When attrition works:**

| Condition | Required? |
|-----------|----------|
| Real scale advantage (even modest) | Yes |
| Sustainable cash position | Yes |
| Patience for long timeline | Yes |
| Competitor has no alternative power source | Helps |

**Why it matters:**

Not all competitive victories are blitzkriegs. When you have modest but real scale economies, the winning strategy may be patience — consistently reinvesting your advantage while competitors gradually exhaust their ability to keep pace. The key is recognizing the game you're playing and having the discipline to play it.
