# 7 Powers: The Foundations of Business Strategy Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Insight: Benefit + Barrier

Most strategy frameworks focus on competitive advantages. 7 Powers focuses on **durable** competitive advantages — those protected by economic structures that prevent arbitrage.

**The To Be or Not To Be Test:**

For any claimed advantage, ask:
1. **Benefit:** Does this create materially higher returns (lower cost OR higher price)?
2. **Barrier:** What prevents competitors from copying this and arbitraging away the advantage?

If you can't answer both, you don't have power.

**Example: Netflix UI Excellence**

Netflix spent enormous resources on UI development — millions of A/B tests, world-class recommendation engines, seamless interfaces. Is this power?

| Benefit | Barrier |
|---------|---------|
| Better user experience may drive retention | Can be copied |

When Blockbuster finally launched their streaming service, their UI was indistinguishable from Netflix. All that UI excellence was *necessary* but not *sufficient* for power. Netflix's actual power comes from scale economies in content costs — spreading $8B+ in content costs over 200M+ subscribers gives them a cost per subscriber advantage that smaller players can't match.

## The Seven Powers

### Power Progression

Not all powers are available at all times. There's a progression:

```
ORIGINATION          TAKEOFF              STABILITY
─────────────────────────────────────────────────────────
Counter-Positioning  Scale Economies      Branding
                     Network Economies    Process Power
                     Switching Costs

Cornered Resource (available at any stage, but rare)
```

**Early stage startups:** Focus on Counter-Positioning (your refuge from incumbents) and think about which of the takeoff powers your business might develop.

**Takeoff phase:** You're in a market share battle. Scale Economies, Network Economies, and Switching Costs become available based on your growth relative to competitors.

**Stability phase:** Branding and Process Power can emerge only after sustained market presence.

---

### 1. Scale Economies

**Definition:** A business with Scale Economies has unit costs that decline as volume increases. Larger players have lower costs than smaller competitors.

**Benefit:** Lower unit costs at higher volumes
**Barrier:** Smaller competitors can't match costs without first achieving scale (chicken-and-egg problem)

**How it works:**

Scale Economies typically come from spreading large fixed costs across more units:

```
Cost per Unit = Fixed Costs / Volume + Variable Costs

Netflix Example:
- Content costs: ~$17B/year (mostly fixed)
- 250M subscribers
- Content cost per subscriber: ~$68/year

Competitor with 25M subscribers:
- Same content quality: ~$17B/year
- Content cost per subscriber: ~$680/year
```

**Key insight:** The curve flattens. At very high volumes, the percentage advantage diminishes. This is why data-based scale economies often don't create power — competitors may be "close enough" on the curve.

**Where to look:**
- Content businesses (spreading content costs)
- Manufacturing (spreading factory costs)
- R&D-heavy businesses (spreading development costs)
- Distribution networks (spreading infrastructure costs)

---

### 2. Network Economies

**Definition:** A business has Network Economies when the value of the product increases as more users join.

**Benefit:** Higher value per user at larger scale (enabling higher prices)
**Barrier:** New entrants start with zero network value

**Critical distinction: Network Effects vs Network Economies**

Network *effects* are common — any platform has some network effects. Network *economies* require those effects to be **material** — large enough to create significant price differentials.

| Network Effects | Network Economies |
|-----------------|-------------------|
| More users = somewhat better | More users = dramatically better |
| Uber/Lyft have network effects | Neither has material network economies |
| LinkedIn has network effects | LinkedIn has network economies (professional network is uniquely valuable) |

**Uber vs Lyft Example:**

Both have network effects (more drivers = shorter wait times). But the advantage from having 10% more drivers isn't material enough to justify significantly higher prices. Result: Neither has network economies, and they compete fiercely on price.

**Where to look:**
- Marketplaces (but verify materiality)
- Social networks (but verify lock-in)
- Platforms with user-generated value
- Products where user data from A improves experience for B

---

### 3. Counter-Positioning

**Definition:** A newcomer adopts a superior business model that the incumbent cannot copy because doing so would damage their existing business.

**Benefit:** Superior business model economics
**Barrier:** Copying would cannibalize incumbent's core business

**This is the startup founder's best friend.**

Counter-positioning explains why large, well-resourced incumbents often fail to respond to obvious threats — not because they're stupid, but because responding rationally would hurt their existing business.

**Classic Examples:**

| Newcomer | Incumbent | Why Incumbent Couldn't Respond |
|----------|-----------|-------------------------------|
| Netflix streaming | Blockbuster | Would cannibalize store revenue + existing late-fee profit model |
| Google search | Yahoo | Yahoo's portal model depended on keeping users on-site; search sends them away |
| Vanguard index funds | Active fund managers | Would admit stock picking doesn't work; cannibalize high-fee products |

**The window closes:** Counter-positioning only works during the takeoff phase. Once you're large enough to be a threat, incumbents may rationally decide to cannibalize themselves. By then, you need other powers (scale, switching costs, etc.) to maintain advantage.

**Where to look:**
- Business models that threaten incumbent economics
- Approaches that require incumbents to admit their model is flawed
- Strategies that would cannibalize existing revenue streams

---

### 4. Switching Costs

**Definition:** Customers face costs (monetary, time, learning, data, etc.) when switching to a competitor, creating lock-in.

**Benefit:** Higher retention and pricing power
**Barrier:** Competitors must overcome switching costs to win customers

**Types of switching costs:**

| Type | Example |
|------|---------|
| Financial | Early termination fees, lost loyalty points |
| Learning | Mastering a new interface, retraining staff |
| Data | Migration costs, losing historical data |
| Integration | Rebuilding workflows, API connections |
| Social | Convincing colleagues to switch together |

**Key insight:** Switching costs must be *durable*. If competitors can reduce switching costs (easy migration tools, data portability), the barrier erodes.

**Enterprise SaaS Example:**

Salesforce has strong switching costs:
- Data migration is complex and risky
- Teams are trained on Salesforce workflows
- Custom integrations with other systems
- Institutional knowledge embedded in configurations

But switching costs alone aren't enough — you also need the benefit (Salesforce genuinely provides value) or customers will bear the cost to escape.

---

### 5. Branding

**Definition:** A business has Branding power when customers are willing to pay more for an objectively identical product based on brand alone.

**Benefit:** Price premium for equivalent product
**Barrier:** Requires extended time and consistent messaging to build

**Critical distinction: Brand Recognition vs Branding Power**

| Brand Recognition | Branding Power |
|-------------------|----------------|
| People know your name | People will pay more for your name |
| Can be bought (Super Bowl ads) | Must be earned over time |
| Necessary but not sufficient | True power |

**Tiffany Test:**

If Tiffany sold an identical diamond ring in a plain box, would customers pay the same price? No — they're paying for the blue box, the heritage, the signal. That's branding power.

**Why it's late-stage:** Branding power comes from sustained emotional connections built over years or decades. Startups can build brand recognition quickly, but branding power takes time and consistency that most early companies can't afford.

**Where to look:**
- Consumer products with emotional purchase decisions
- Status-signaling categories (luxury, fashion)
- Products where quality is hard to evaluate objectively
- Heritage brands with multi-generational presence

---

### 6. Cornered Resource

**Definition:** A business has preferential access to a valuable resource that others cannot replicate.

**Benefit:** Value from the resource
**Barrier:** Exclusive access (often legal protection)

**The transfer test:** A cornered resource must be valuable to *any* owner, not just you. If you gave the resource to a competitor, would it be valuable to them?

**Examples:**

| Resource | Why Cornered |
|----------|--------------|
| Pharmaceutical patents | Legal protection (20 years) |
| Mining rights | Exclusive contracts/ownership |
| Key talent | Non-competes, equity, culture |
| Proprietary data | Collected over time, not replicable |
| Government licenses | Regulatory barrier |

**Rare in tech:** Most tech "resources" (talent, code, data) can be replicated or poached. True cornered resources in tech are rare — usually patents or exclusive content deals.

---

### 7. Process Power

**Definition:** A company's processes and organizational culture create lower costs or better products through embedded knowledge that cannot be transferred.

**Benefit:** Superior operational outcomes
**Barrier:** Opacity — competitors can't understand or replicate the process

**The rarest power.**

Most operational excellence is *not* Process Power because it can be mimicked:
- Hire consultants with best practices
- Recruit employees from competitors
- Reverse-engineer visible processes

**True Process Power requires opacity:**
- So complex that outsiders can't understand it
- So embedded in culture that it can't be documented
- So tacit that employees can't transfer it

**Toyota Example:**

Toyota's production system took decades to develop. Despite publishing books about it, sending consultants to teach it, and allowing factory tours, competitors struggled to replicate it. Why? The knowledge was embedded in thousands of small decisions, cultural norms, and tacit practices that couldn't be extracted.

**Heuristic:** If there's a consulting firm that can bring you "up to speed" on this practice, it's not Process Power.

---

## The Three Components of Business Value

Hamilton Helmer identifies three — and only three — things that create business value:

1. **Market Size** — How big is the opportunity?
2. **Power** — Can you sustain differentiated returns?
3. **Operational Excellence** — Can you execute effectively?

All three matter, but they serve different purposes:

| Component | Creates Value By | Can Be Mimicked? |
|-----------|------------------|------------------|
| Market Size | Expanding opportunity | N/A — external factor |
| Power | Protecting returns | No — that's the definition |
| Operational Excellence | Achieving potential | Yes — always |

**The treadmill:** Most of your day as an operator will be spent on operational excellence. If you stop, competitors will overtake you. But this effort maintains position — it doesn't create durable advantage. You're running on a treadmill. Power is what lets you step off and still lead.

## How to Assess Power

### Step 1: Identify Claimed Advantages

List everything your company/business claims as competitive advantages:
- Our technology
- Our team
- Our data
- Our brand
- Our customer relationships
- Our cost structure
- Our speed of execution

### Step 2: Apply the Benefit Test

For each claimed advantage:
- Does this create materially lower costs? How much?
- Does this enable higher prices? How much?
- Can you quantify the differential?

### Step 3: Apply the Barrier Test

For each advantage with a benefit:
- What prevents competitors from copying this?
- Is that barrier structural (economic) or just temporal (we did it first)?
- Will the barrier strengthen or weaken over time?

### Step 4: Map to the 7 Powers

If there's both benefit and barrier, which power does it represent?
- Fixed cost spreading → Scale Economies
- Value increases with users → Network Economies
- Incumbent can't copy → Counter-Positioning
- Lock-in after purchase → Switching Costs
- Price premium for identical product → Branding
- Exclusive resource ownership → Cornered Resource
- Inimitable process → Process Power

If it doesn't map to a power, it's operational excellence — valuable but not durable.

## Common Mistakes

### 1. Confusing operational excellence with power
"We have the best team" or "we move fastest" is a treadmill. If you stop, competitors catch up. It's necessary but not sufficient.

### 2. Claiming branding power for brand recognition
Paying for awareness isn't power. Power is when customers pay more for an objectively identical product because of your brand.

### 3. Assuming all network effects create network economies
Network effects must be *material* — significant enough to create meaningful price differentials. Uber and Lyft both have network effects but neither has network economies.

### 4. Believing data automatically creates scale economies
Data advantages flatten quickly. If competitors have "enough" data to be competitive, more data doesn't help. The curve matters.

### 5. Thinking switching costs are always durable
Switching costs only create power if they persist. Data portability laws, migration tools, and changing standards can erode switching costs over time.

### 6. Missing the timing of power
Counter-positioning is available early; branding and process power are available late. Trying to develop the wrong power at the wrong stage wastes resources.

## Applying 7 Powers: A Checklist

### For Evaluating a Business (Investment/Competitive Analysis)

- [ ] What power(s) does this business claim?
- [ ] What's the specific benefit (cost or price)?
- [ ] What's the barrier preventing imitation?
- [ ] Is the benefit material (large enough to matter)?
- [ ] Is the barrier durable (will it persist)?
- [ ] What stage is the business in (origination/takeoff/stability)?
- [ ] Is the claimed power appropriate for this stage?

### For Designing a Startup

- [ ] Does our approach create counter-positioning against incumbents?
- [ ] What would an incumbent have to give up to copy us?
- [ ] Which takeoff powers (scale, network, switching) could we develop?
- [ ] What characteristics of our business tilt toward these powers?
- [ ] Are we targeting a market size worth defending?

### For Competing in Takeoff Phase

- [ ] What's our current source of power against direct competitors?
- [ ] Are we winning the market share battle that determines scale-based powers?
- [ ] How do new technology developments affect our power position?
- [ ] What operational excellence is required to maintain position while building power?

### For Defending an Established Business

- [ ] What is our source of power?
- [ ] What would erode this power?
- [ ] How do we invest in strengthening barriers?
- [ ] Are there adjacent opportunities where we could develop new power?

## Quick Reference

**The core idea:** Power = Benefit + Barrier. You need both to have durable competitive advantage.

**The seven powers:**
1. Scale Economies — Lower unit costs at higher volume
2. Network Economies — Value increases with users (must be material)
3. Counter-Positioning — Incumbents can't copy without damaging themselves
4. Switching Costs — Customers face costs when leaving
5. Branding — Price premium for identical product
6. Cornered Resource — Exclusive access to valuable asset
7. Process Power — Inimitable operational excellence (rare)

**Power progression:**
- Early stage: Counter-Positioning
- Takeoff: Scale, Network, Switching Costs
- Stability: Branding, Process Power
- Anytime (rare): Cornered Resource

**The test:** Does this create material benefit? What prevents copying?

---

