---
name: shape-up
description: Use when asked to "shape up", "run a shaping session", "set an appetite", "scope a project without estimates", "betting table", or "ship in fixed cycles". Helps teams escape estimate-driven development and Scrum fatigue. The Shape Up method (created by Ryan Singer at Basecamp/37signals) uses fixed time boxes, variable scope, and collaborative shaping to ship meaningful work predictably.
---

# Shape Up

## What It Is

Shape Up is a product development methodology built on one core insight: **you cannot estimate your way to shipping—you must shape your way there.**

Traditional approaches ask "How long will this take?" and then try to hit that estimate. Shape Up flips this: decide upfront how much time you're willing to spend (the *appetite*), then shape a version of the solution that fits within that constraint.

The methodology emerged from 17 years of building Basecamp, where the founding team faced an unusual constraint: their only engineer (DHH) worked just 10 hours per week. This forced extreme clarity about what to build and ruthless scoping to ensure every hour counted. As the company grew, they formalized these practices into Shape Up to maintain startup speed at scale.

**The key shift:** Move from "What's the estimate for this?" to "What version of this can we confidently ship in the time we're willing to spend?"

## When to Use It

Use Shape Up when you need to:

- **Stop projects from dragging** — work that should take weeks is taking months
- **Escape the estimate trap** — you're tired of estimates that are always wrong
- **Give teams real autonomy** — not just ticket execution
- **Reduce meeting overhead** — Scrum rituals are consuming your time
- **Ship meaningful chunks** — not just incremental tickets that don't add up to anything
- **Align product and engineering** — there's a wall between them today
- **Maintain startup speed** — as you scale past 30-50 people

## When Not to Use It

Don't use Shape Up when:

- **You're 3 people or fewer** — just talk to each other, formalization isn't needed yet
- **There's no real complexity** — simple tasks don't need shaping
- **You can't get engineering into shaping** — without technical input, shaping fails
- **Leadership isn't bought in** — you need exec support to protect build time
- **You're doing pure maintenance** — bug fixes don't need the full process

## Patterns

Detailed examples showing how to apply Shape Up correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [estimates-vs-appetite](patterns/estimates-vs-appetite.md) | Don't ask "how long?" — decide how much time you're willing to spend |
| [unshaped-work](patterns/unshaped-work.md) | A Figma file or PRD is not shaped work — you need collaborative clarity |
| [shaping-without-engineering](patterns/shaping-without-engineering.md) | Shaping without a senior engineer is a recipe for blowups |
| [ten-pound-bag](patterns/ten-pound-bag.md) | You can't put 10 pounds of scope in a 5 pound time box |
| [fuzzy-problem](patterns/fuzzy-problem.md) | "Build a calendar" is not a problem — narrow it down first |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [too-abstract-shaping](patterns/too-abstract-shaping.md) | Fat marker sketches must communicate the idea, not just be blurry wireframes |
| [scope-hammering](patterns/scope-hammering.md) | Cut scope before you start, not when you're out of time |
| [tickets-not-projects](patterns/tickets-not-projects.md) | Give teams whole projects, not shredded tickets |
| [hill-chart-theater](patterns/hill-chart-theater.md) | Hill charts show real progress, not status theater |
| [missing-kickoff](patterns/missing-kickoff.md) | Builders must translate shaped work into 9 or fewer implementation scopes |
| [cool-down-skipping](patterns/cool-down-skipping.md) | Teams need breathing room between cycles to reset |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [betting-table-dysfunction](patterns/betting-table-dysfunction.md) | Betting is a real commitment, not a backlog shuffle |
| [junior-detail-dial](patterns/junior-detail-dial.md) | Adjust shaping detail based on who's building |
| [circuit-breaker-fear](patterns/circuit-breaker-fear.md) | If it's not working, stop building and return to shaping |


## Deep Dives

Read only when you need extra detail.

- `references/shape-up-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Shape Up* by Ryan Singer — the original free book (basecamp.com/shapeup)
- *Demand-Side Sales 101* by Bob Moesta — for the framing/problem discovery phase
- *Competing Against Luck* by Clayton Christensen — Jobs-to-be-Done theory

**Courses:**
- *Shaping in Real Life* — Ryan Singer's course on practical shaping

**Other:**
- Ryan Singer's website: ryansinger.co
- 37signals blog for ongoing insights

---

*Credit: Shape Up was created by Ryan Singer during his 17 years at Basecamp/37signals. This skill is based on his book and podcast conversations.*
