---
title: Narrow the Problem First
impact: CRITICAL
tags: framing, problem-definition, scope, calendar
---

## Narrow the Problem First

You cannot shape "calendar." You cannot shape "dashboard." You have to narrow the problem before shaping can begin.

**Incorrect (shaping a fuzzy concept):**

> **PM:** "We need to build a calendar feature. Let's shape it."
>
> *In the shaping session...*
>
> **Designer:** "Should it have day, week, and month views?"
>
> **Engineer:** "What about recurring events?"
>
> **PM:** "And shared calendars?"
>
> **Engineer:** "We need to think about time zones..."
>
> **Designer:** "What about integrations with Google Calendar?"
>
> *3 hours later...*
>
> **PM:** "We've identified 47 things a calendar could do. No idea how to fit this in 6 weeks."

The shaping session became an explosion of possibilities because the problem was never narrowed.

**Correct (narrow the problem first):**

> **PM (before shaping):** "Users keep requesting a calendar. But what's the actual struggle?"
>
> **Customer Support:** "They say they can't see empty spaces. Our agenda view only shows scheduled events."
>
> **PM:** "So the problem isn't 'we need a calendar.' It's 'I need to see where I have free time.'"
>
> *In the shaping session...*
>
> **PM:** "We're solving one thing: users need to see empty spaces. That's the frame."
>
> **Designer:** "What if we show a dot grid for the month — just dots where events exist?"
>
> **Engineer:** "And tapping a day shows the agenda for just that day?"
>
> **PM:** "That's it. That's the shape. A 2-month dot grid with a sliding agenda view."

By narrowing the problem to "see empty spaces," the team could shape a specific solution in 20 minutes instead of spiraling for 3 hours.

**Why it matters:**

Shaping a fuzzy problem is like trying to pack for "a trip." Pack for what trip? To the beach? To the mountains? For a week? An ever-expanding blob has no shape. A narrow problem — "see empty spaces" — can be solved.
