---
title: Fat Marker Sketches Must Communicate
impact: HIGH
tags: shaping, sketches, breadboards, clarity
---

## Fat Marker Sketches Must Communicate

A fat marker sketch isn't a blurry wireframe. It must communicate the idea clearly enough that someone says "I know what to build."

**Incorrect (abstract blob):**

> **PM (presenting shaped work):** "Here's the fat marker sketch for the new onboarding flow."
>
> *Shows a sketch with boxes labeled "Step 1", "Step 2", "Step 3", "Welcome Screen"*
>
> **Engineer:** "Okay... but what's in each step?"
>
> **PM:** "That's for the team to figure out. We shaped at the right level of abstraction."
>
> **Engineer:** "I still don't know what we're building. Is step 2 a form? An interactive tutorial? A video?"

The sketch avoided detail but also avoided meaning. It's just a blurry version of nothing.

**Correct (fat marker with intent):**

> **PM (presenting shaped work):** "Here's the shaped onboarding. Three screens:"
>
> *Shows a sketch with clear elements:*
> - **Screen 1:** "What's your role?" with 4 radio buttons: Engineer, Designer, PM, Other
> - **Screen 2:** "What do you want to do first?" with 3 cards: "Create a project", "Join a team", "Import data"
> - **Screen 3:** Based on choice, either project wizard OR team invite flow
>
> **Engineer:** "Got it. Role selector, then a router that branches to different starting points. I know exactly what to build."

The sketch is still rough — no colors, no pixel-perfect layouts — but it communicates the actual idea.

**Why it matters:**

The goal of a fat marker sketch isn't to avoid detail — it's to avoid unnecessary detail while keeping essential clarity. Ask yourself: "Would a builder know what to go make?" If the answer is no, your sketch is too abstract, not appropriately rough.
