---
title: Shaped Work vs. Documents
impact: CRITICAL
tags: shaping, prds, figma, artifacts, process
---

## Shaped Work vs. Documents

A PRD or Figma file is not shaped work. Shaping produces collaborative clarity — something everyone can hold in their head and build confidently.

**Incorrect (PRD as shaping):**

> **PM:** "I've finished shaping the dashboard feature. Here's the 15-page PRD with requirements, user stories, and acceptance criteria. And here are 30 Figma screens showing every state."
>
> **Engineer (reading):** "Okay... I think I understand. Let me start building."
>
> *Week 3...*
>
> **Engineer:** "Wait, this screen doesn't make sense technically. The data doesn't work this way. And this flow has 4 edge cases we didn't account for."
>
> **PM:** "Can you just figure it out? We're running out of time."

The PRD looked thorough, but it was written without engineering input. The Figma file looked beautiful, but it didn't account for technical reality.

**Correct (collaborative shaping):**

> **PM:** "Let's shape the dashboard. Sarah (senior engineer), can you join for a 3-hour session tomorrow?"
>
> *In the session...*
>
> **PM:** "We need to show key metrics. Users are asking for this every week."
>
> **Engineer:** "If you want real-time data, that's expensive. But if we can show yesterday's stats, it's easy — we already cache that."
>
> **Designer (sketching):** "What about a simple 4-panel layout with the top metrics?"
>
> **Engineer:** "Wait — the API for one of those metrics doesn't exist. We'd need 2 weeks just for that."
>
> **PM:** "Okay, let's cut that metric. What's our final list?"
>
> **All:** "4 panels: revenue, active users, signups, churn rate. All from cached data. One drill-down each."

Now everyone understands the same thing. The engineer knows it's buildable. The designer knows the scope. There are no hidden time bombs.

**Why it matters:**

Documents are one-directional — they describe an imagined future. Shaping is collaborative — it discovers what's actually possible. The Figma file will explode on first contact with engineering reality. Shaped work has already survived that contact.
