---
name: strategic-narrative
description: Use when asked to "strategic narrative", "Andy Raskin", "tell our company story", "write a pitch deck", "explain why customers should care", or "movement narrative". Helps craft compelling narratives that define movements rather than just selling products. The Strategic Narrative framework (created by Andy Raskin) transforms pitches from feature lists into stories about change.
---

# Strategic Narrative

## What It Is

Strategic Narrative is a framework for crafting the one story that drives everything: sales, marketing, product, fundraising, and recruiting. The core insight: **don't pitch your product as the solution to a problem — position it as the path to winning a new game the world is playing.**

The traditional pitch structure is what Andy Raskin calls "the arrogant doctor": You have a problem, I have a solution, let me tell you why mine is better. This sets you up for feature comparison and bragging.

Strategic Narrative flips this entirely. Instead of leading with pain points, you lead with a shift in the world — from an old game to a new game. You're not selling a treatment; you're defining a movement and inviting people to join.

**The key shift:** Move from "Here's your problem, here's our solution" to "The world has changed, here's how winners are playing, and we'll help you win."

## When to Use It

Use Strategic Narrative when you need to:

- **Create a sales deck or pitch** that resonates beyond features
- **Position a product** in a crowded market where feature comparison fails
- **Align company teams** (sales, marketing, product) around one story
- **Fundraise** with a compelling vision investors can rally behind
- **Recruit** by articulating a mission people want to join
- **Differentiate from competitors** without feature-by-feature comparisons
- **Scale beyond founder-led sales** by giving teams a story to tell

**Best fit:** B2B enterprise technology companies with complex products and group buying decisions. The framework excels when products change frequently and feature comparisons become meaningless.

## When Not to Use It

- **Simple consumer purchases** — people comparing specs on a shelf (watches, appliances)
- **Pure commodity products** — where price truly is the only differentiator
- **Products with no real choice** — employer-mandated software, regulated purchases
- **Very early stage** — before you've talked to customers and understand the shift
- **When you just need a tagline** — this creates the underlying story, not just words

## Patterns

Detailed examples showing how to apply Strategic Narrative correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [leading-with-product](patterns/leading-with-product.md) | Start with the shift, not your solution |
| [vague-shift](patterns/vague-shift.md) | Name the old game and new game concretely |
| [missing-stakes](patterns/missing-stakes.md) | Without stakes, there's no urgency to act |
| [promised-land-is-features](patterns/promised-land-is-features.md) | The goal is an outcome, not your product's capabilities |
| [no-proof](patterns/no-proof.md) | Show winners already playing the new game |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [category-without-story](patterns/category-without-story.md) | A category name without narrative falls flat |
| [features-as-benefits](patterns/features-as-benefits.md) | Features are magic gifts that overcome obstacles |
| [obstacles-as-problems](patterns/obstacles-as-problems.md) | Obstacles are barriers to the promised land, not pain points |
| [arrogant-doctor](patterns/arrogant-doctor.md) | Don't pitch like you're diagnosing and treating |
| [telling-not-inviting](patterns/telling-not-inviting.md) | Pose the question, make them co-adventurers |
| [one-size-fits-all](patterns/one-size-fits-all.md) | Same structure, different emphasis for different audiences |
| [copying-others-deck](patterns/copying-others-deck.md) | You can't just copy someone else's deck |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [skipping-the-shift](patterns/skipping-the-shift.md) | Even known shifts need articulation |
| [too-many-words](patterns/too-many-words.md) | Old game/new game should be 2-4 words each |
| [shift-they-dont-feel](patterns/shift-they-dont-feel.md) | The shift must resonate with their experience |


## Deep Dives

Read only when you need extra detail.

- `references/strategic-narrative-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**From Andy Raskin:**
- "The Greatest Sales Deck I've Ever Seen" — the viral post analyzing Zuora's deck
- The Bigger Narrative podcast — interviews with CEOs about their narratives
- AndyRaskin.com — articles and frameworks

**Related Reading:**
- *Story* by Robert McKee — the screenwriting foundation Raskin drew from
- *Play Bigger* — the category design book (related but different focus)
- *Building a StoryBrand* by Donald Miller — another narrative framework

**For Testing:**
- Run your shift by 5-10 prospects
- Ask: "Am I crazy, or are you seeing this?"
- If they engage and elaborate, you've got it
