# Strategic Narrative Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Framework: Five Elements

Strategic Narrative has five essential elements that build on each other:

### 1. Name the Shift (Old Game → New Game)

Every great strategic narrative starts with a fundamental change in the world. Not a problem, but a **shift** — from how things used to work to how they work now.

```
OLD GAME                    →    NEW GAME
Software (own & maintain)   →    Cloud (subscribe & scale)
Transactions (one-time)     →    Subscriptions (ongoing)
Opinions (gut feeling)      →    Reality (data-driven)
Top-down learning           →    Upskill from within
Outbound (interruption)     →    Inbound (attraction)
```

**What makes a good shift:**
- Feels inevitable, not just your opinion
- Names both sides concisely (2-4 words each)
- Customer says "Yeah, I'm seeing that" when you describe it
- Creates two camps: those playing the old game, those playing the new

**Archetypical example:** Salesforce didn't say "our CRM is better than Siebel." They said "Software is over. The cloud is the new way to win. Siebel? That's the old game."

### 2. Name the Stakes (Winners and Losers)

Once you've named the shift, show that this isn't academic — there are winners and losers. Some companies are thriving by playing the new game. Others are dying by playing the old one.

**How to establish stakes:**
- Point to companies already winning the new game
- Show the decline of those stuck in the old game
- Make it feel like life or death (even if it's business life/death)

**Example (Zuora):** "Look at all the winning companies — Airbnb, Box, Netflix — they're all subscriptions. Meanwhile, Fortune 500 companies are dying faster than ever. The ones sticking to the transaction model? They're next."

This is like George Lucas killing Luke's aunt and uncle. Until the stakes are clear, Luke (your prospect) says "I can't really get involved. I've got to go home." Once stakes are life-and-death, they're ready to act.

### 3. Name the Object of the New Game

What does winning look like? The "object of the new game" is the rallying cry — the outcome everyone should pursue. It flows naturally from the shift and becomes almost like a company mission.

**Great examples:**
- Zuora: "Turn customers into subscribers"
- Airbnb: "Belong anywhere" / "Live there"
- Gong: "See reality, not opinions"
- Drift: "Talk to prospects now, not later"

**What makes a good object:**
- Asymptotically unachievable (you're always pursuing it)
- Simple enough to remember
- Works as a question: "What would it take to [object]?"
- Becomes the test for product decisions

**Framing as a question:** "We asked a simple question: What would it take to turn every customer into a subscriber?" This makes the prospect a co-adventurer in the story.

### 4. Name the Obstacles

If the object were easy to achieve, you wouldn't need to exist. The obstacles are what make the new game hard — and they set up your product as the solution.

**Key insight:** These sound like problems, but they're repackaged. By first establishing the shift and stakes, you've made these obstacles *emotionally meaningful*. They're not just pain points — they're barriers to a promised land the prospect now wants.

**Example (Zuora):**
- "How will you measure lifetime value instead of transactions?"
- "How will you track changing preferences over time?"
- "How will your billing system handle ongoing relationships?"

These are the monsters in Lord of the Rings. The Empire in Star Wars. Without them, there's no story.

### 5. Show How to Overcome (Magic Gifts + Proof)

Now — and only now — do you talk about your product. But frame it as the "magic gifts" that help the hero overcome obstacles and win the new game.

**The key difference:**
- Arrogant doctor: "We have features X, Y, Z that solve problems A, B, C"
- Strategic narrative: "Here's how we help you overcome obstacle 1, 2, 3 to achieve [object of the game]"

**Then prove it:** Show success stories of companies that adopted the new game (with your help) and are winning. These aren't case studies about your features — they're stories about customers who made the shift and thrived.

## The Structure in Action

Here's how 360Learning applied the framework:

| Element | Old Approach | Strategic Narrative |
|---------|--------------|---------------------|
| **The Shift** | "We do collaborative learning" | "Top-down learning → Upskill from within" |
| **The Stakes** | "Training is expensive" | "Companies that can't upskill fast enough are dying. Look at Google — their experts teach everyone." |
| **The Object** | "Better training" | "Turn your experts into champions" |
| **The Obstacles** | "Training is hard" | "How do you make it easy for anyone to create a course? How does L&D keep control?" |
| **The Solution** | "Our features..." | "Here's how we help you upskill from within..." |

**Result:** The CEO stopped getting asked "How are you different from [other learning platform]?" The conversation shifted from feature comparison to "Are we ready to play the new game?"

## How to Build Your Strategic Narrative

### Step 1: Draft the Shift

Interview customers and ask:
- "What was going on when you started looking?"
- "What changed that made this urgent?"
- "What were you doing before?"

Listen for patterns. What old approach were they abandoning? What new approach were they embracing?

### Step 2: Test the Shift

In sales conversations, describe the shift and ask: "Am I crazy, or are you seeing this?" Watch for:
- Nodding along
- "Yeah, let me tell you how that's playing out for us"
- Engagement increases, not blank stares

If they're not feeling the shift, you have the wrong shift — or the wrong prospect.

### Step 3: Name the Stakes

Find examples of:
- Companies winning by playing the new game
- Companies struggling or dying by playing the old game
- Industry trends that support the shift

### Step 4: Articulate the Object

Boil down what winning looks like to a phrase. Test it as a question: "What would it take to [object]?" Does it make sense? Does it feel aspirational?

### Step 5: Map Obstacles to Your Capabilities

List what makes the new game hard. Then map your product capabilities to each obstacle. This becomes the structure of your product presentation.

### Step 6: Collect Proof

Gather stories of customers who:
- Made the shift
- Overcame the obstacles (with your help)
- Are now winning the new game

Frame these as movement stories, not vendor case studies.

## Common Mistakes

### 1. Leading with the product
The shift comes first. If you start with "We're a [category] that does [features]," you've already lost.

### 2. Vague or abstract shift
"The world is changing" is not a shift. "Digital transformation" is too broad. Name the specific old game and new game in 2-4 words each.

### 3. No stakes
Without winners and losers, there's no urgency. Show that playing the old game leads somewhere bad.

### 4. Promised land is just features
"Our platform does X, Y, Z" is not a promised land. "Turn customers into subscribers" is.

### 5. Copying someone else's deck
You can't just put your logo on the Zuora deck. The shift must be authentic to your market.

### 6. Category name without story
"Collaborative learning" or "conversational marketing" means nothing without the old game → new game story behind it.

## Applying Strategic Narrative: Checklists

### For Sales Decks

- [ ] Does it open with the shift, not your product?
- [ ] Is the old game → new game named in 2-4 words each?
- [ ] Are winners of the new game shown early?
- [ ] Is the object of the game clear and aspirational?
- [ ] Are obstacles framed as barriers to the object (not just problems)?
- [ ] Are features presented as ways to overcome obstacles?
- [ ] Does it end with proof of others winning the new game?

### For Product Roadmap

- [ ] Does this feature help customers play the new game?
- [ ] Does it help overcome one of the key obstacles?
- [ ] Does it move customers toward the object?
- [ ] If not, why are we building it?

### For Marketing Content

- [ ] Is content organized around the shift (not product features)?
- [ ] Do blog posts/content show others winning the new game?
- [ ] Does messaging emphasize the movement, not the vendor?
- [ ] Are we creating "trend pieces" about the shift, not just product announcements?

### For Recruiting

- [ ] Does the job posting articulate the mission (object of the game)?
- [ ] Does it describe the shift candidates will be part of?
- [ ] Does it feel like joining a movement, not just a company?

### For Fundraising

- [ ] Does the pitch lead with market shift, not product?
- [ ] Are the stakes clear (big opportunity, big risk of missing it)?
- [ ] Is the object something investors can rally behind?
- [ ] Is traction framed as proof of the movement, not just revenue?

## Signs Your Narrative Needs Work

- Prospects keep asking "How are you different from [competitor]?"
- Sales requires founders in every call to close
- Marketing content is all product announcements
- Different teams tell different stories
- Customers can't explain why they bought you
- You're losing on features/price comparisons

## The Second Session Will Suck

When building a strategic narrative with a team, expect this:
1. **Session 1:** Brainstorm all the possibilities. Everyone contributes gold.
2. **Session 2:** Present a draft. It throws out 90% of the ideas. People are disappointed.
3. **Session 3+:** Iterate based on feedback. The narrative gets better.

Having a "shit draft" is infinitely more valuable than having great ideas. Test it, learn, iterate.

---

