---
title: Seek Information That Proves You Wrong
impact: MEDIUM
tags: confirmation-bias, research, evidence, decisions
---

## Seek Information That Proves You Wrong

Confirmation bias makes you seek evidence that supports your existing beliefs and discount evidence that contradicts them. The antidote is deliberately seeking disconfirming information.

**Incorrect (confirmation bias in research):**

> **Product decision meeting:**
>
> PM: "We should add a social sharing feature. I talked to 5 power users and they all said they'd use it."
>
> VP: "Great. Did anyone say they wouldn't use it?"
>
> PM: "I focused on people who I thought would be interested. Why would I talk to people who wouldn't want it?"

The PM only gathered evidence that supported their hypothesis. They have no idea how many users would ignore or dislike the feature.

**Correct (deliberately seeking disconfirmation):**

> **Product decision meeting:**
>
> PM: "We should add a social sharing feature. Here's what I found:
> - 5 power users said they'd use it (I picked these because I expected them to be positive)
> - 3 casual users said they wouldn't—they find sharing 'performative' and prefer our product because it's private
> - 2 churned users said social features are why they left a competitor
>
> So the signal is mixed: power users want it, but there's a segment that values privacy. We might gain some users but alienate others."
>
> VP: "That's a much more complete picture. Let's design it as opt-in and keep privacy as our default."

By seeking disconfirming evidence, the PM surfaced a real risk and enabled a better decision.

**Techniques to counter confirmation bias:**

1. **Steelman the opposition:** Before deciding, write the strongest argument against your position.
2. **Assign a devil's advocate:** Have someone's explicit job be to argue the other side.
3. **Seek out critics:** Talk to people who would be expected to disagree.
4. **Ask "What would change my mind?":** If you can't name evidence that would change your view, you're not being rational.
5. **Adversarial collaboration:** Like Daniel Kahneman—find someone who disagrees and design a test together.

**Why it matters:**

Confirmation bias is invisible. You genuinely believe you're being objective. The only protection is process—deliberately seeking evidence that would prove you wrong. If you only look for supporting evidence, you'll always find it.
