---
title: Separate Discovery, Discussion, and Decision
impact: CRITICAL
tags: meetings, process, groupthink, independence
---

## Separate Discovery, Discussion, and Decision

Most meetings try to do three things at once: discover what people think, discuss it, and decide. This contaminates opinions and produces groupthink. Only discussion belongs in a meeting.

**Incorrect (all three in the meeting):**

> **Roadmap planning meeting:**
>
> VP Product: "Okay team, what should our top priority be this quarter?"
>
> Senior PM (confident, speaks first): "I think we need to focus on enterprise features. Our biggest customers are asking for SSO and audit logs."
>
> Junior PM 1: "Yeah, that makes sense..."
>
> Junior PM 2: "I was going to say mobile, but I can see the enterprise logic."
>
> VP Product: "Great, sounds like we're aligned. Enterprise it is."

The senior PM anchored everyone. The junior PMs had different views but conformed. The VP thinks there's consensus when there isn't.

**Correct (discover independently, discuss in meeting, decide after):**

> **Before the meeting (discover):**
>
> VP Product emails: "Please rank our top 5 potential priorities 1-5 and write 3 sentences on your reasoning. Reply only to me—don't discuss with others."
>
> **Results come in:**
> - Senior PM: Enterprise (SSO, audit logs)
> - Junior PM 1: Mobile (50% of signups are mobile, 20% retention)
> - Junior PM 2: Mobile (competitor just launched mobile-first)
> - Engineer Lead: Performance (churn exit surveys cite speed)
>
> **In the meeting (discuss):**
>
> VP Product: "Here's the spread of opinions. Two of you said mobile, one enterprise, one performance. Let's discuss. Sarah, tell us more about the mobile retention data."
>
> [Each person explains their reasoning. VP reflects back without opinion. Focus is on understanding disagreement, not achieving agreement.]
>
> **After the meeting (decide):**
>
> VP Product: "I've heard everyone. I'm deciding mobile is our top priority. I know this isn't what you recommended, Marcus—nevertheless, here's the reasoning..."

Now the VP has real information (not contaminated by anchoring), the team feels heard, and the decision is clear.

**Why it matters:**

When opinions are shared in real-time, the loudest, most confident, or most senior person dominates. You lose the diversity of thought. Independent collection preserves the true spread of opinion—which is what you need to make good decisions.
