---
title: What Seems Obvious Now Wasn't Obvious Then
impact: HIGH
tags: hindsight-bias, retrospectives, learning, post-mortems
---

## What Seems Obvious Now Wasn't Obvious Then

Hindsight bias makes past events seem predictable once you know the outcome. This distorts learning—you can't improve decisions if you believe you "should have known" things that were unknowable at the time.

**Incorrect (hindsight bias in a retrospective):**

> **Post-mortem after a competitor launched first:**
>
> VP: "How did we not see this coming? It was obvious they were going to launch a mobile app."
>
> PM: "Well, at the time, all their public statements were about enterprise..."
>
> VP: "But their CTO tweeted about React Native 8 months ago! We should have known."
>
> PM: "I guess... we should have been paying closer attention."

The VP is reconstructing history with information they didn't have or didn't interpret that way at the time. The "obvious" signal only seems obvious because the outcome happened.

**Correct (separating what was knowable from what seems obvious now):**

> **Post-mortem after a competitor launched first:**
>
> VP: "Let's be careful about hindsight bias here. What did we actually know, and when?"
>
> PM: "At decision time in January: their public roadmap was enterprise-focused, their last 3 hires were backend infrastructure, and their CEO said mobile was 'not a 2024 priority' at the conference."
>
> VP: "What about the CTO's React Native tweet?"
>
> PM: "It was one tweet among hundreds. We'd need evidence that we should have weighted it higher."
>
> VP: "Fair. So given what we knew in January, was our decision reasonable?"
>
> PM: "Yes. But what we can improve: we didn't have a systematic way to monitor competitor signals. We could add quarterly competitor hiring analysis."

Now the team is learning something actionable (improve competitor monitoring) rather than beating themselves up for not predicting the unpredictable.

**Questions to combat hindsight bias:**

- "What did we actually know at decision time?"
- "If we went back to that moment, with only that information, would we decide differently?"
- "Is the 'obvious' signal only obvious because we know how it turned out?"
- "What would have had to be true for us to act on that signal then?"

**Why it matters:**

Hindsight bias makes you overconfident about your ability to predict the future ("I knew it all along") and overly harsh on past decisions ("We should have seen it"). Neither helps you make better decisions. The goal is to identify what was knowable but not known—that's where process improvements live.
