---
title: Make Intuitions Explicit So You Can Test Them
impact: CRITICAL
tags: intuition, explicit, learning, process
---

## Make Intuitions Explicit So You Can Test Them

Your intuition is sometimes right. But if you never make it explicit, you never find out when it's wrong—and you can never improve.

**Incorrect (keeping intuition implicit):**

> **Investment committee meeting:**
>
> Partner 1: "I like this founder. She's got something."
>
> Partner 2: "Yeah, I agree. There's a quality there."
>
> Partner 1: "I think we should do it."
>
> [They invest. Company fails 2 years later.]
>
> **Post-mortem:**
>
> Partner 1: "Well, you never know. Sometimes they don't work out."

Nothing was learned. "She's got something" can't be evaluated, improved, or taught to anyone else.

**Correct (making intuition explicit):**

> **Investment committee meeting:**
>
> Partner 1: "I like this founder. Let me make explicit what I mean—she's deeply in the problem space, she's recruited two world-class engineers already, and she articulates customer pain in language I've never heard a founder use."
>
> Partner 2: "I'll add: she's showing intellectual honesty about risks."
>
> **Before investing, they record:**
> - Founder quality: 6/7
> - Market quality: 5/7
> - Product differentiation: 4/7
> - Probability of Series A: 70%
>
> [Company fails 2 years later.]
>
> **Post-mortem:**
>
> Partner 1: "We rated founder quality 6/7 but she's now 0 for 2. Let's look at our founder assessments across all investments. Are we systematically overrating founders with strong communication skills?"
>
> [Analysis reveals they are. They update their founder assessment rubric.]

Now they've learned something. The explicit ratings created a feedback loop.

**Why it matters:**

"I just know a good [hire/investment/market] when I see one" is not learnable, teachable, or improvable. Making it explicit—writing down what "good" means, rating it, tracking it—lets you discover when your intuition is wrong. That's how you get better.
