---
title: No Feedback Loop Is Actually Long
impact: HIGH
tags: feedback-loops, signals, learning, measurement
---

## No Feedback Loop Is Actually Long

"Our feedback loop is too long to evaluate decisions" is a choice, not a constraint. Every outcome has intermediate signals that correlate with success. Find them, forecast them, and learn faster.

**Incorrect (accepting a long feedback loop):**

> **Venture fund annual meeting:**
>
> LP: "How do we know if your investments are good decisions? You won't have exits for 10 years."
>
> GP: "That's the nature of our business. We have to wait and see. We're confident in our portfolio, but we won't know for sure until the exits."
>
> [Partners have no way to learn or improve until a decade passes.]

The 10-year feedback loop is a choice. Plenty of signals happen before an exit.

**Correct (finding intermediate signals):**

> **Venture fund annual meeting:**
>
> LP: "How do we evaluate decision quality with 10-year exit timelines?"
>
> GP: "We shortened the feedback loop. At investment time, we forecast intermediate signals:
> - Probability of Series A funding (learn in 12-18 months)
> - Product-market fit indicators (learn in 6-12 months)
> - Ability to retain key hires (learn continuously)
>
> Every company that's exited well funded at Series A. So we forecast it, then measure it. We're 73% accurate on Series A predictions—better than random. We're learning and improving."

Now the fund can evaluate decision quality in 18 months, not 10 years.

**How to shorten any feedback loop:**

1. **Name the eventual outcome** you care about (exit value, project success, etc.)
2. **List what must happen** for that outcome to occur (intermediate milestones)
3. **Identify which milestones are correlated** with eventual success
4. **Forecast those milestones** at decision time
5. **Track forecasts vs. actuals** as milestones occur

**Common intermediate signals:**

| Domain | Long Outcome | Shorter Signal |
|--------|--------------|----------------|
| Venture | Exit (10 years) | Series A (18 months), PMF metrics (6 months) |
| Product | Revenue impact (2 years) | Adoption rate (3 months), retention (1 month) |
| Hiring | Long-term performance (2 years) | 90-day ramp, peer feedback (3 months) |
| Strategy | Market share (5 years) | Early adoption segments (1 year) |

**Why it matters:**

Long feedback loops feel safe—you don't have to confront whether you're wrong. But they're an excuse, not a necessity. Find intermediate signals, and you can learn 5-10x faster than competitors who "wait and see."
