---
title: Pre-mortems Need Kill Criteria to Matter
impact: CRITICAL
tags: premortems, kill-criteria, planning, quitting
---

## Pre-mortems Need Kill Criteria to Matter

Pre-mortems (imagining failure and working backward) feel productive but rarely change behavior. Research shows they don't improve outcomes unless you attach committed actions—kill criteria—to the signals you identify.

**Incorrect (pre-mortem without kill criteria):**

> **Project kickoff:**
>
> PM: "Let's do a pre-mortem. Imagine it's 6 months from now and this project failed. What went wrong?"
>
> Team brainstorms:
> - "We underestimated the integration complexity."
> - "The key engineer quit mid-project."
> - "Requirements kept changing."
> - "We ran out of budget."
>
> PM: "Great list. Let's keep these in mind as we go."
>
> [6 months later: All four things happened. Nobody acted on any of the signals.]

The pre-mortem identified risks but created no commitment to act. When the signals appeared, the team rationalized continuing.

**Correct (pre-mortem with kill criteria):**

> **Project kickoff:**
>
> PM: "Let's do a pre-mortem. Imagine it's 6 months from now and this project failed. What went wrong?"
>
> Team brainstorms the same list. Then:
>
> PM: "Now, for each risk—what's the early signal, and what will we do if we see it?"
>
> | Risk | Early Signal | Kill Criteria |
> |------|--------------|---------------|
> | Integration complexity | >2 weeks spent on a single integration | Stop. Reassess architecture. If no path forward in 1 week, kill project. |
> | Key engineer quits | Engineer gives notice | If no replacement hired within 2 weeks, pause project and re-scope. |
> | Requirements keep changing | 3rd scope change request | Freeze scope. Any changes require project restart with new timeline. |
> | Run out of budget | 60% budget spent at 40% completion | Escalate to exec team. Either get more budget or kill. |
>
> PM: "We're committing to these actions now, in writing. When we see the signal, we follow through—no renegotiating in the moment."

Now the pre-mortem changes behavior because the team committed to actions before cognitive biases kicked in.

**Why it matters:**

In the moment, when the signal appears, you'll rationalize: "It's different this time." "We're so close." "We can't waste what we've invested." The only way to overcome these biases is to commit to action before you're in the fog of war.
