---
title: Don't Judge Decisions by Outcomes
impact: CRITICAL
tags: resulting, decision-quality, outcome-bias
---

## Don't Judge Decisions by Outcomes

Resulting is judging the quality of a decision by how it turned out. This is backwards—luck always plays a role, and the outcome tells you almost nothing about whether the decision was good.

**Incorrect (resulting):**

> **Post-mortem after a failed product launch:**
>
> PM: "We made a bad decision to target enterprise customers first."
>
> VP: "What did you know at the time?"
>
> PM: "Well, our research showed enterprise had higher willingness to pay, faster sales cycles in our category, and better retention. We had three customer interviews supporting it."
>
> VP: "So why was it a bad decision?"
>
> PM: "Because it failed. We only closed 2 deals in 6 months."

The PM is judging the decision by the outcome. The decision process was sound—the result was bad luck, market timing, or factors unknown at decision time.

**Correct (separating decision quality from outcome quality):**

> **Post-mortem after a failed product launch:**
>
> PM: "The launch didn't work—we only closed 2 deals."
>
> VP: "Let's evaluate the decision, not the outcome. What was our process?"
>
> PM: "We had 3 customer interviews, market sizing data, and clear criteria for why enterprise first."
>
> VP: "Was there information we could have gathered but didn't?"
>
> PM: "Actually, yes—we didn't talk to any enterprise buyers who chose competitors. That would have revealed the procurement blocker we hit."
>
> VP: "Good. The outcome was bad, but the decision process was okay—missing one step. Next time, add competitive loss interviews to our criteria."

Now the team learns something actionable about their process, not just "enterprise was wrong."

**Why it matters:**

Resulting teaches you nothing. You can't learn from an outcome when luck was involved. You can only learn by examining what you knew, what you didn't know, and what you could have known. Bad outcomes from good decisions shouldn't change your process. Good outcomes from bad decisions shouldn't reinforce them.
