---
title: Past Investment Is Irrelevant to Future Decisions
impact: HIGH
tags: sunk-cost, quitting, decisions, waste
---

## Past Investment Is Irrelevant to Future Decisions

Sunk cost fallacy is continuing something because of what you've already invested, rather than what you'd gain going forward. The investment is gone either way—only future value matters.

**Incorrect (letting sunk costs drive decisions):**

> **Quarterly review meeting:**
>
> PM: "The analytics dashboard feature is struggling. Usage is 5% of what we projected, customers say it's confusing, and it's consuming 40% of our engineering capacity."
>
> VP: "But we've spent 8 months and $400K on it. We can't just abandon that."
>
> PM: "What if we give it 2 more months?"
>
> VP: "Fine. Let's see if we can turn it around. We've invested too much to stop now."
>
> [4 months later: still failing. Now they've spent 12 months and $600K.]

The 8 months and $400K were gone regardless. The decision to continue added 4 more months and $200K to the loss.

**Correct (ignoring sunk costs, evaluating future value only):**

> **Quarterly review meeting:**
>
> PM: "The analytics dashboard is struggling. Usage is 5% of projected, customers are confused, it's consuming 40% of engineering."
>
> VP: "Set aside what we've spent. If we were starting from zero today, would we build this?"
>
> PM: "No. The market feedback is clear—they don't want a dashboard, they want automated alerts."
>
> VP: "Then the question is: what's the best use of our engineering time starting now? Is continuing this better than the alternatives?"
>
> PM: "No. Pivoting to alerts would take 2 months. Continuing the dashboard would take 4 more months and probably still fail."
>
> VP: "Kill the dashboard. Reallocate to alerts. The $400K is gone either way—let's not add to it."

The VP made the decision based on future value, not past investment.

**The reframe:**

Instead of: "But we've already invested X!"

Ask: "If we were starting fresh today, would we choose to do this?"

If no, then continuing is the waste—not stopping.

**Why it matters:**

Every day you continue something that isn't working, you're choosing to invest more. Sunk costs create a psychological trap that keeps you pouring resources into losing bets. The antidote is to always ask: "Starting from today, what's the best path forward?"
