# Thinking in Bets Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Insight: Decision Quality vs. Outcome Quality

The biggest mistake in decision-making is **resulting**—judging the quality of a decision by its outcome.

```
                    OUTCOME
              Good          Bad
         ┌──────────┬──────────┐
    Good │ Deserved │   Bad    │
DECISION │  Success │   Luck   │
         ├──────────┼──────────┤
    Bad  │  Dumb    │ Deserved │
         │  Luck    │  Failure │
         └──────────┴──────────┘
```

**Example: Poker Hand**

You have pocket Aces (best starting hand in poker). Your opponent has 7-2 offsuit (worst starting hand). You go all-in. You're 87% to win. They hit a miracle flush and win.

- **Your decision:** Excellent. You got your money in with 87% equity.
- **Your outcome:** Terrible. You lost everything.
- **Was it a bad decision?** No. The decision was mathematically correct.

**Example: Hiring**

You hired someone who interviewed brilliantly and had a stellar resume. Six months later, they're underperforming.

- **Resulting says:** Bad decision, they're not working out.
- **Thinking in Bets says:** Was the process good? Did you use structured interviews? Did you get independent opinions? The outcome tells you nothing about decision quality.

**Key insight:** You can improve decision quality. You cannot control luck. Focus on what you can control.

## Make Implicit Explicit

Your intuition is sometimes right. But if you never make it explicit, you never find out when it's wrong.

**How to make intuition explicit:**

1. **Before a meeting:** Ask everyone to submit their opinions independently
2. **On forecasts:** Don't say "It'll take about 3 months." Say "I'm 80% confident it'll take 2-4 months."
3. **On judgment calls:** Define what you mean. "Good market" means what, exactly?
4. **On hiring:** What specific criteria make someone a "good fit"? Write them down before interviewing.

**Why this matters:**

- You can't improve what you can't measure
- You can't learn from mistakes you don't acknowledge
- You can't share wisdom that lives only in your head

## The Meeting Revolution: Discover, Discuss, Decide

Most people think meetings are for three things:
1. **Discover** what people think
2. **Discuss** those opinions
3. **Decide** what to do

**Only the middle one should happen in a meeting.**

### Discover: Before the Meeting (Independently)

Send prompts beforehand and collect responses independently (no reply-all):
- "What do you think the timeline for this feature is?"
- "Rank these priorities from most to least important."
- "What are the biggest risks you see?"

**Why independently?** When you share opinions in a group:
- The loudest person dominates
- The most senior person anchors everyone
- Confident people have outsized influence (regardless of accuracy)
- People conform to avoid conflict

### Discuss: In the Meeting

Now that you have everyone's independent views:
- Share the spread of opinions with the group
- Focus discussion on **disagreements**, not agreements
- Facilitator reflects back without adding opinion: "So what I heard you say is..."
- No interrupting, no "I disagree"—only clarifying questions

### Decide: After Discussion (Often by One Person)

- Either a single decision-maker decides, informed by the discussion
- Or people vote independently (not in the room, not by show of hands)
- No expectation of "alignment"—that's coercion disguised as consensus

## The Four Forces of Change

(Similar to JTBD, but applied to any decision, not just purchasing)

```
                    ┌─────────────────┐
     F1: Push      │                 │      F2: Pull
  (current pain)   │   DECISION      │   (new solution)
       ────────────►│   TO CHANGE     │◄────────────
                    │                 │
                    └────────┬────────┘
                             │
              ───────────────┼───────────────
                             │
                    ┌────────┴────────┐
     F3: Anxiety   │                 │      F4: Habit
    (of new thing) │   DECISION TO   │   (of status quo)
       ────────────►│   STAY PUT      │◄────────────
                    └─────────────────┘
```

For any change to happen: **F1 + F2 must exceed F3 + F4**

**Insight:** Often, reducing Anxiety and Habit (friction) is easier than amplifying Push and Pull.

**Example:** A condo developer couldn't sell units to downsizers. The problem wasn't the condo—it was the friction of moving. Solution: Include moving services and 2 years of storage. Sales increased 30%.

## Pre-mortems + Kill Criteria

A pre-mortem is imagining the project failed and asking: "Looking back, what went wrong?"

**Pre-mortems alone don't change behavior.** Research shows that doing pre-mortems without structure rarely changes plans.

**The fix: Attach kill criteria to every signal.**

### Example: Sales Team Kill Criteria

| Signal | Kill Criteria |
|--------|---------------|
| RFP was clearly written for a competitor | Ask directly if they're working with a competitor. If yes and they're far along, kill. |
| Customer only wants to talk about price | Kill. They're using you to beat up someone else. |
| Can't get a decision-maker in the room | Offer executive alignment. If declined, kill. |

### How to Set Kill Criteria

1. **Run the pre-mortem:** "It's 6 months from now and this failed. What happened?"
2. **List the early signals:** What would you have seen that indicated failure?
3. **For each signal, define an action:** If we see X, we will do Y.
4. **Commit in writing:** This isn't optional. Write it down before you start.

## There Is No Long Feedback Loop

A common excuse: "We can't evaluate our decisions because the feedback loop is 10 years."

**This is false.** The feedback loop is as long as you choose to make it.

**How to shorten any feedback loop:**

1. **Identify intermediate signals** that correlate with the eventual outcome
2. **Forecast those signals** at decision time
3. **Track actual results** against your forecasts
4. **Learn and adjust** much faster

**Example: Venture Capital**

- "Our feedback loop is 10 years (until exit)."
- "Did you invest and go to sleep for 10 years? Or did things happen in between?"
- Intermediate signals: Does it fund at Series A? Achieve product-market fit? Retain top talent?
- Every company that exited well funded at Series A. That's a signal—track it.

**At First Round Capital:** Partners now forecast the probability of funding at Series A at the time of their seed investment. They find out in 12-16 months, not 10 years. They can now evaluate decision quality.

**Why people resist short feedback loops:**
- It feels safe to not know if you're wrong
- If you're a "celebrity investor" because of one big hit, you don't want to discover it was luck
- Short loops mean confronting uncomfortable truths

## Nevertheless: The Leadership Word

When you've heard everyone and need to decide, use "nevertheless."

**The pattern:**

1. Reflect back what you heard: "I understand you believe X because of Y."
2. Acknowledge the disagreement: "I can see this isn't going the way you'd prefer."
3. Decide: "Nevertheless, here's what we're going to do."

**Why it works:**
- People feel heard (because you reflected their view accurately)
- No false promise of alignment
- Clear decision authority
- No coercion—you're not trying to make them agree

**Example:**
> "I hear that you think we should extend the deadline by two weeks, and your reasoning about quality makes sense. Nevertheless, we're shipping on Friday. Here's how we'll handle the gaps..."

## Common Mistakes

### 1. Resulting (judging decisions by outcomes)
The biggest one. A bad outcome doesn't mean bad decision. A good outcome doesn't mean good decision.

### 2. Keeping intuitions implicit
"I just know a good deal when I see one" is not learnable or improvable. Make it explicit.

### 3. Running meetings that discover, discuss, AND decide
You contaminate everyone's opinions. Separate the phases.

### 4. Pre-mortems without kill criteria
Writing down what could go wrong feels productive. Without committed actions, it changes nothing.

### 5. Claiming long feedback loops
You're choosing not to find intermediate signals. There's always something correlated with success that you can measure sooner.

### 6. Seeking alignment
Nobody actually agrees. Pretending they do is coercive and creates false confidence.

### 7. Overweighting confidence
The most confident person is often wrong. Confidence and accuracy are poorly correlated.

## Applying Thinking in Bets: Checklists

### For Evaluating Past Decisions

- [ ] What did we know at the time of the decision? (Not now—then.)
- [ ] Was our process good? (Structured, independent opinions, explicit criteria)
- [ ] Did we consider the full range of outcomes, or just the most likely?
- [ ] What would we do differently in the process? (Not "I wish we'd known X")
- [ ] Is the outcome teaching us about decision quality or about luck?

### For Making New Decisions

- [ ] Have we made our assumptions explicit?
- [ ] Have we gathered opinions independently before discussing?
- [ ] What's our probability range, not just our point estimate?
- [ ] What intermediate signals will tell us if we're on track?
- [ ] What are our kill criteria? What would make us quit early?
- [ ] Who is the decision maker? (Not "the group")

### For Running Better Meetings

- [ ] Did we send prompts and collect independent opinions beforehand?
- [ ] Are we spending time on disagreements, not agreements?
- [ ] Is the facilitator reflecting without adding opinion?
- [ ] Are we avoiding "I disagree" and "You're wrong"?
- [ ] Is the decision being made outside the meeting (by DRI or independent vote)?
- [ ] Are we okay with people leaving without "alignment"?

### For Shortening Feedback Loops

- [ ] What's the eventual outcome we care about?
- [ ] What intermediate signals must occur for that outcome to happen?
- [ ] How quickly can we measure those signals?
- [ ] Are we forecasting those signals at decision time?
- [ ] Are we tracking forecasts against actuals?

### For Pre-mortems

- [ ] Have we imagined the project failed and listed why?
- [ ] Have we identified early warning signals for each failure mode?
- [ ] Have we attached a specific action to each signal?
- [ ] Have we written down the kill criteria before starting?
- [ ] Have we committed to following through (not just hoping we will)?

## Quick Reference

**The core idea:** Separate decision quality from outcome quality. You can only control decisions, not luck.

**Make implicit explicit:** Intuition is fine, but write it down so you can test it.

**Meetings:** Discover independently, discuss in person, decide outside the room.

**Pre-mortems:** Useless without kill criteria. Commit to actions in writing.

**Feedback loops:** They're only long if you choose not to find intermediate signals.

**Alignment:** Doesn't exist. Stop pretending it does. Use "nevertheless" and move on.

---

