---
title: Novelty Effects Fade — Run Long Enough
impact: HIGH
tags: runtime, novelty, primacy, user-behavior
---

## Novelty Effects Fade — Run Long Enough

Users often react positively to "new" and "different" — not necessarily "better." Initial lifts frequently fade as users get used to changes. Short experiments can't tell the difference.

**Incorrect (one-week test):**

> **Week 1 Results:**
> - New homepage design: +15% engagement
> - P < 0.01
> - "Ship it!"
>
> **Week 4 after launch:**
> - Engagement back to baseline
> - PM: "The experiment clearly showed improvement. Why isn't it lasting?"

Users were clicking around the new design out of curiosity, not because it was genuinely better. Once they'd explored it, behavior returned to normal.

**Correct (testing long enough):**

> **Experiment Design:**
> - Planned duration: 4 weeks
> - Rationale: Allow novelty effect to wear off
>
> **Week 1:** +15% engagement
> **Week 2:** +8% engagement
> **Week 3:** +3% engagement
> **Week 4:** +1% engagement (not significant)
>
> PM: "The effect decayed. This isn't a real improvement — users were just exploring something new."
>
> Data Scientist: "Right. If we'd stopped at week 1, we'd have shipped a change that adds no long-term value. Let's iterate on the design."

**Why it matters:**

Novelty effects can be substantial — double-digit lifts that vanish in weeks. The opposite (primacy effects, where users prefer familiar) also exists. Running for 2-4 weeks helps you see stable, real effects rather than transient reactions to change. One full week is the minimum (to capture weekly cycles), but 2-4 weeks is better for significant UX changes.
