---
name: working-backwards
description: Use when asked to "working backwards", "PR/FAQ", "Amazon PR/FAQ", "write a press release", "define a new product", or "write a customer-focused PRD". Helps define products by starting with the customer problem and desired outcome before building. The Working Backwards process (developed at Amazon) forces clarity on customer value before committing engineering resources.
---

# Working Backwards

## What It Is

Working Backwards is Amazon's product development methodology. The core insight: **start with the customer problem and work backward to the solution, not the other way around.**

Most teams work forward: "We have this technology/capability/idea — what can we build with it?" Working Backwards inverts this: "What problem does the customer have? What would the ideal solution look like? Now, how do we build it?"

The mechanism: Write an internal press release and FAQ *before* building anything. If you can't write a compelling press release, you don't have a compelling product.

As Jeff Bezos put it: "We took it as an article of faith — if we served customers well, if we prioritized customers and delivered for them, things like sales, revenue, and free cash flow would follow."

## When to Use It

Use Working Backwards when you need to:

- **Define a new product or major feature** before committing resources
- **Evaluate competing product ideas** and choose which to build
- **Align stakeholders** on what you're building and why
- **Force clarity** on vague product concepts
- **Prevent building solutions in search of problems**
- **Create a shared vision** that engineering, design, and leadership can rally around
- **Decide whether an idea is worth pursuing** at all

## When Not to Use It

- The work is incremental optimization (A/B tests, bug fixes)
- You're executing on an already-defined product
- The scope is too small to warrant the overhead
- You're just exploring technical feasibility (do that first, then write the PR/FAQ)

## Patterns

Detailed examples showing how to apply Working Backwards correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [solution-first-thinking](patterns/solution-first-thinking.md) | Don't start with the solution and retrofit a problem |
| [missing-problem-paragraph](patterns/missing-problem-paragraph.md) | If you skip the problem, there probably isn't one |
| [vague-customer-definition](patterns/vague-customer-definition.md) | "Everyone" is not a customer — be specific |
| [writing-pr-after-building](patterns/writing-pr-after-building.md) | The PR comes first, not as documentation after |
| [internal-jargon-in-pr](patterns/internal-jargon-in-pr.md) | Press releases are for customers, not engineers |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [faq-avoids-hard-questions](patterns/faq-avoids-hard-questions.md) | The FAQ must address what makes you uncomfortable |
| [hyperbole-instead-of-specifics](patterns/hyperbole-instead-of-specifics.md) | No marketing fluff — use data and concrete claims |
| [customer-quote-sounds-fake](patterns/customer-quote-sounds-fake.md) | Customer quotes reveal whether you understand the job |
| [too-many-features](patterns/too-many-features.md) | One press release, one compelling benefit |
| [no-measurable-outcome](patterns/no-measurable-outcome.md) | Define what success looks like with numbers |
| [combining-ideas](patterns/combining-ideas.md) | One PR/FAQ per idea — don't bundle concepts |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [skipping-the-iteration](patterns/skipping-the-iteration.md) | PR/FAQs improve through concentric circle review |
| [missing-the-date](patterns/missing-the-date.md) | The hypothetical launch date signals ambition and scope |
| [faq-too-short](patterns/faq-too-short.md) | External and internal FAQs serve different purposes |


## Deep Dives

Read only when you need extra detail.

- `references/working-backwards-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Working Backwards* by Bill Carr and Colin Bryar — the definitive guide from former Amazon VPs
- *The Everything Store* by Brad Stone — context on Amazon's culture and innovation

**Templates:**
- Working Backwards PR/FAQ Template (available at workingbackwards.com)

**Podcasts:**
- Bill Carr on Lenny's Podcast — deep dive on implementing Working Backwards
- Ian McAllister on Lenny's Podcast — practical application of the process

**Other:**
- *Good to Great* by Jim Collins — influenced Amazon's thinking on flywheels and focus
- *The Lean Startup* by Eric Ries — complementary approach to validating ideas

---

*Credit: The Working Backwards process was developed at Amazon, primarily during 2004-2007. Key contributors include Jeff Bezos, Bill Carr, Colin Bryar, Jeff Wilke, and many others. This skill synthesizes insights from Bill Carr and Ian McAllister's interviews on Lenny's Podcast.*
