---
title: One PR/FAQ Per Idea — Don't Bundle Concepts
impact: HIGH
tags: scope, process, evaluation
---

## One PR/FAQ Per Idea — Don't Bundle Concepts

Each PR/FAQ should represent one discrete product or feature idea. Bundling multiple ideas together prevents proper evaluation and kills the funnel.

**Incorrect (bundled ideas):**

> **PR/FAQ Title:** "Smart Seller Tools: Inventory, Pricing, and Analytics"
>
> **Press Release:** "Today we announce three powerful new tools..."
>
> **In the Leadership Review:**
>
> VP: "I love the inventory syncing idea. The analytics piece feels underbaked. And I'm not sure about the pricing — have we validated that sellers want automated pricing?"
>
> PM: "Well... they're all connected. We built the architecture to support all three."
>
> VP: "So we can't do just the inventory piece?"
>
> PM: "Not really. It's kind of all or nothing."
>
> *Result:* The strong idea (inventory) is held hostage by the weak ones. The project gets delayed for "more research" on the parts that aren't ready.

**Correct (separate PR/FAQs):**

> **Three separate documents:**
>
> 1. "Inventory Sync: Real-time inventory across all channels"
> 2. "Smart Pricing: Automated price optimization"
> 3. "Seller Analytics: See what's working in one dashboard"
>
> **In the Leadership Review:**
>
> VP: "I love Inventory Sync — let's green-light that. Seller Analytics needs more customer validation before I'm comfortable. Smart Pricing is interesting but lower priority. Let's revisit in Q3."
>
> *Result:* The strong idea moves forward. The others get appropriate treatment: more research, or deprioritization. No hostage situations.

**Why it matters:**

Bill Carr describes the goal: "You're trying to create a product funnel, not a product tunnel. With a funnel, lots of things at the top, fewer things at the bottom. The tunnel means that everything that comes in is also going to come out the other side."

Bundling ideas creates tunnels. You lose the ability to prioritize, kill weak ideas, and move fast on strong ones. Keep ideas atomic.
