---
title: No Marketing Fluff — Use Data and Concrete Claims
impact: HIGH
tags: press-release, specificity, metrics
---

## No Marketing Fluff — Use Data and Concrete Claims

Press releases should be factual and data-rich. Superlatives and marketing language signal that you haven't done the work to understand real customer impact.

**Incorrect (hyperbole and fluff):**

> **Press Release:**
>
> "Today, Amazon announced a revolutionary new shopping experience that will transform the way customers discover products. This game-changing innovation leverages cutting-edge AI to deliver best-in-class recommendations. Customers will enjoy a seamless, world-class experience that takes personalization to the next level."
>
> *What's wrong:* Every sentence uses hyperbole. "Revolutionary," "game-changing," "cutting-edge," "best-in-class," "seamless," "world-class," "next level" — none of these tell you anything concrete. A customer reading this learns nothing.

**Correct (specific and data-grounded):**

> **Press Release:**
>
> "Today, Amazon announced improvements to product discovery that help customers find what they want faster. In testing with 50,000 customers, the new experience reduced average search-to-purchase time by 35% — from 8.2 minutes to 5.3 minutes. Customers were twice as likely to say they 'found exactly what they were looking for' (67% vs. 34% previously).
>
> The improvement comes from combining search history, browse behavior, and purchase patterns to surface products customers are likely to want. Unlike previous recommendation systems that only considered past purchases, this approach anticipates needs — showing customers winter coats in October before they search for them, or suggesting replacement filters when their air purifier is likely running low."

**Why it matters:**

Bill Carr notes: "You try to write it in that way, but the one thing is you don't want to use hyperbole. It would be very factual with numbers, data rich document too."

Specific numbers force clarity. If you can't say "35% faster" because you don't know if it will be 35% faster, that's a sign you need more research before writing the PR/FAQ — not a reason to fall back on "game-changing."
