---
title: Define What Success Looks Like With Numbers
impact: HIGH
tags: metrics, success-criteria, faq
---

## Define What Success Looks Like With Numbers

Every PR/FAQ should include concrete success metrics. If you can't define what success looks like, you can't evaluate whether the product worked.

**Incorrect (vague success criteria):**

> **FAQ Section:**
>
> Q: How will we measure success?
> A: We'll track customer satisfaction, usage metrics, and business impact.
>
> Q: What are our goals?
> A: To significantly improve the customer experience and grow the business.
>
> *What's wrong:* A year from now, how do you know if you succeeded? "Significantly improve" could mean anything. This FAQ provides no way to evaluate the investment.

**Correct (specific success criteria):**

> **FAQ Section:**
>
> Q: How will we measure success?
> A: Primary metric: % of eligible customers who activate the feature within 30 days of availability.
>
> Target: 15% activation in first quarter, 30% by end of year.
>
> Secondary metrics:
> - Feature retention (% of activators still using weekly after 90 days): Target 60%
> - Customer-reported time saved: Target 5+ hours/week (via survey)
> - Oversell incidents for feature users vs. non-users: Target 75% reduction
>
> Q: What's our kill criteria?
> A: If activation is below 5% after 90 days, we'll sunset the feature. If retention is below 30%, we'll pause new development and investigate before continuing.
>
> Q: What ROI do we expect?
> A: At target activation and retention, we project $2.4M ARR within 18 months against $800K total investment (engineering, support, infrastructure). Break-even at ~10 months post-launch.

**Why it matters:**

Amazon's culture of input metrics and weekly business reviews creates accountability. Bill Carr describes: "We were hyperfocused on those inputs and the input metrics... we would develop our operating plans and review our business each week."

If you can't define success metrics upfront, you can't learn from the outcome — and you can't honestly evaluate whether this idea deserves resources over competing ideas.
