---
title: PR/FAQs Improve Through Concentric Circle Review
impact: MEDIUM
tags: process, review, iteration
---

## PR/FAQs Improve Through Concentric Circle Review

A PR/FAQ isn't written once and submitted. It goes through iterative review with progressively larger audiences. Skipping this iteration produces weaker documents and weaker products.

**Incorrect (straight to leadership):**

> **PM's Approach:**
>
> Writes PR/FAQ over a weekend. Reviews it once. Sends to VP for approval.
>
> **In the Review:**
>
> VP: "Have you thought about how this interacts with the Mobile team's roadmap?"
>
> PM: "I... hadn't considered that."
>
> VP: "And this cost estimate seems low. Did you check with Finance?"
>
> PM: "I was going to after approval."
>
> VP: "Let's come back to this in a month after you've done more homework."
>
> *Result:* The PM looks unprepared. The idea is delayed. Trust is eroded.

**Correct (concentric circle review):**

> **PM's Approach:**
>
> 1. **Self-review:** Writes first draft. Sleeps on it. Revises. Realizes the problem paragraph is weak. Does more customer research.
>
> 2. **Small team (2-3 people):** Shares with trusted peers. Gets feedback: "The customer quote doesn't sound real." Rewrites it based on actual customer language from interviews.
>
> 3. **Wider team:** Presents to full product team + eng lead. Discovers conflict with Mobile roadmap. Revises solution to avoid dependency or addresses it in FAQ.
>
> 4. **Cross-functional:** Shares with Finance, Legal, Operations. Cost estimate gets refined. Legal flags a regulatory concern — added to FAQ with mitigation plan.
>
> 5. **Leadership review:** Presents polished document. Every hard question has been anticipated. VP asks tough questions — the FAQ already addresses them.
>
> *Result:* Approval. The PM looks prepared. The idea has been stress-tested.

**Why it matters:**

Bill Carr explains: "There's this iterative nature to writing PR/FAQs where it's sort of a concentric circle review. You start off small with one author and with low fidelity writing these things, and then you start to share them with a small group and get feedback and improve it, a wider group, get feedback and improve it, and onward and onward."

This iteration isn't bureaucracy — it's stress-testing. Ideas that can't survive peer review shouldn't reach leadership.
