---
title: Don't Start With the Solution
impact: CRITICAL
tags: methodology, common-mistakes, customer-focus
---

## Don't Start With the Solution

Working Backwards means starting with the customer problem, not with technology or capabilities you want to use. If you have a solution in mind before defining the problem, you're working forward.

**Incorrect (solution-first thinking):**

> **Product Team Discussion:**
>
> "We have this great machine learning model and this recommendation engine. What if we combined them? We could build an 'ASIN-to-ASIN linking' feature where products are linked by subjective attributes and customers could vote on them."
>
> The team builds the feature. It launches. It fails.
>
> *Post-mortem:* "The technology was cool, but customers didn't need another way to browse products. We built a solution looking for a problem."

This is exactly what happened with an early Amazon project. As Ian McAllister recalls: "The name they had for this project was ASIN-to-ASIN linking... it really wasn't working backwards."

**Correct (problem-first thinking):**

> **Product Team Discussion:**
>
> "We've interviewed 15 customers who abandoned their carts in the last month. The top reason? They couldn't tell if a product would actually fit their space. They said things like 'I spent 20 minutes reading reviews trying to figure out if this desk would fit under my window.'"
>
> "What if we helped customers visualize products in their space before buying?"
>
> The team writes a PR/FAQ focused on "helping customers feel confident a product will fit" — then explores what technology could solve that.

**Why it matters:**

Ian McAllister describes the red flag: "If you start talking about those things or the technology, I think that's a likely case that you're not really working backwards." The ingredients in your pantry (your capabilities) should not determine the meal. The customer's hunger should.
