---
title: "Everyone" Is Not a Customer
impact: CRITICAL
tags: customer-definition, press-release, specificity
---

## "Everyone" Is Not a Customer

A press release for "everyone" or "all businesses" isn't a real press release. If you can't define specifically who has this problem, you don't understand the problem well enough.

**Incorrect (vague customer):**

> **Press Release:**
>
> "Amazon announces a new inventory management solution for businesses of all sizes. Whether you're a solo entrepreneur or a Fortune 500 company, our tool helps you manage inventory more efficiently..."
>
> *What's wrong:* A solo entrepreneur running an Etsy shop and a Fortune 500 retail chain have completely different inventory problems. This press release solves neither.

**Correct (specific customer):**

> **Press Release:**
>
> "Amazon announces a new inventory management solution for e-commerce sellers with 50-500 SKUs who sell on multiple channels. These sellers — typically 2-10 person operations running $500K-$5M in annual revenue — face a specific challenge: keeping inventory counts in sync across Amazon, Shopify, eBay, and their own website. When counts get out of sync, they either oversell (angering customers and damaging seller ratings) or undersell (missing revenue by showing 'out of stock' when products are available)..."

**Why it matters:**

Bill Carr emphasizes this point: "The first two things are the things that are hardest to define, like who's the customer? Like anyone says, 'All restaurants are my customer.' Okay, well, that's a mistake. Which kinds of restaurants are your customers? In what kinds of cities? In what kinds of formats?"

Specificity isn't limiting — it's clarifying. You can always expand later. You can't build something great for a customer you can't describe.
